/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.shader;

import com.lowdragmc.shimmer.ShimmerConstants;
import java.nio.FloatBuffer;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;

public class ShaderSSBO {
    public final int id;
    private boolean inValid = false;
    private static final int BUFFER_TYPE = 37074;

    public static boolean support() {
        return GL.getCapabilities().GL_ARB_shader_storage_buffer_object;
    }

    public ShaderSSBO() {
        if (!ShaderSSBO.support()) {
            String errorMessage = "need support for GL_ARB_shader_storage_buffer_object";
            ShimmerConstants.LOGGER.error(errorMessage);
            Minecraft.m_91087_().m_231412_(new CrashReport(errorMessage, (Throwable)new IllegalStateException(errorMessage)));
        }
        this.id = GL43.glGenBuffers();
    }

    public void close() {
        if (!this.inValid) {
            GL30.glDeleteBuffers((int)this.id);
            this.inValid = true;
        } else {
            ShimmerConstants.LOGGER.error("try closing an already closed ShaderStorageBufferObject");
        }
    }

    public void bindBuffer() {
        GL30.glBindBuffer((int)37074, (int)this.id);
    }

    public void unBindBuffer() {
        GL30.glBindBuffer((int)37074, (int)0);
    }

    public void bindToShader(int programIndex, int storageBlockIndex, int index) {
        this.bindBuffer();
        GL43.glShaderStorageBlockBinding((int)programIndex, (int)storageBlockIndex, (int)index);
        this.unBindBuffer();
    }

    public void bindIndex(int index) {
        this.bindBuffer();
        GL43.glBindBufferBase((int)37074, (int)index, (int)this.id);
        this.unBindBuffer();
    }

    public void getSubData(long offset, float[] data) {
        this.bindBuffer();
        GL43.glGetBufferSubData((int)37074, (long)offset, (float[])data);
        this.unBindBuffer();
    }

    public void createBufferData(long size, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)37074, (long)size, (int)mode);
        this.unBindBuffer();
    }

    public void createBufferData(FloatBuffer data, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)37074, (FloatBuffer)data, (int)mode);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, FloatBuffer data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (FloatBuffer)data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, float[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (float[])data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, int[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (int[])data);
        this.unBindBuffer();
    }
}

