/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.shader;

import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;

public class ShaderUBO {
    public final int id = GL30.glGenBuffers();
    private boolean inValid;
    private int blockBinding = -1;

    private void close() {
        if (!this.inValid) {
            GL30.glDeleteBuffers((int)this.id);
            this.inValid = true;
        }
    }

    public void bindBuffer() {
        GL30.glBindBuffer((int)35345, (int)this.id);
    }

    public void unBindBuffer() {
        GL30.glBindBuffer((int)35345, (int)0);
    }

    public void createBufferData(long size, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)35345, (long)size, (int)mode);
        this.unBindBuffer();
    }

    public void createBufferData(FloatBuffer data, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)35345, (FloatBuffer)data, (int)mode);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, FloatBuffer data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)35345, (long)offset, (FloatBuffer)data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, float[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)35345, (long)offset, (float[])data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, int[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)35345, (long)offset, (int[])data);
        this.unBindBuffer();
    }

    public void blockBinding(int blockBinding) {
        this.blockBinding = blockBinding;
        if (blockBinding > -1) {
            GL31.glBindBufferBase((int)35345, (int)blockBinding, (int)this.id);
        }
    }

    public void bindToShader(int program, String bufBlockName) {
        if (this.blockBinding > -1) {
            GL31.glUniformBlockBinding((int)program, (int)GL31.glGetUniformBlockIndex((int)program, (CharSequence)bufBlockName), (int)this.blockBinding);
        }
    }
}

