/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.google.gson.annotations.SerializedName;
import com.lowdragmc.shimmer.config.BlockChecker;
import com.lowdragmc.shimmer.config.FluidChecker;
import com.lowdragmc.shimmer.config.Light;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;

public class BlockLight
extends Light
implements BlockChecker,
FluidChecker {
    @SerializedName(value="block")
    public String blockName;
    @SerializedName(value="fluid")
    public String fluidName;
    @SerializedName(value="state")
    @Nullable
    public Map<String, String> state;

    @Override
    public void check() {
        super.check();
        Asserts.check((StringUtils.isNotEmpty((CharSequence)this.blockName) || StringUtils.isNotEmpty((CharSequence)this.fluidName) ? 1 : 0) != 0, (String)"field block or fluid must be specified for BlockLight");
        Asserts.check((!StringUtils.isNotEmpty((CharSequence)this.blockName) || !StringUtils.isNotEmpty((CharSequence)this.fluidName) ? 1 : 0) != 0, (String)"can't set block and fluid at same time");
    }

    public boolean hasState() {
        return this.state != null && !this.state.isEmpty();
    }

    @Override
    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public String getFluidName() {
        return this.fluidName;
    }
}

