/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.google.gson.annotations.SerializedName;
import com.lowdragmc.shimmer.config.BlockChecker;
import com.lowdragmc.shimmer.config.Check;
import com.lowdragmc.shimmer.config.FluidChecker;
import com.lowdragmc.shimmer.config.KeyShared;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;

public class Bloom
extends KeyShared
implements Check,
BlockChecker,
FluidChecker {
    @SerializedName(value="fluid")
    public String fluidName;
    @SerializedName(value="particle")
    public String particleName;
    @SerializedName(value="block")
    public String blockName;
    @SerializedName(value="state")
    public Map<String, String> state;

    @Override
    public void check() {
        int i = 0;
        if (StringUtils.isNotEmpty((CharSequence)this.fluidName)) {
            ++i;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.particleName)) {
            ++i;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.blockName)) {
            ++i;
        }
        Asserts.check((i == 1 ? 1 : 0) != 0, (String)"only of Field fluid, particle or block can be specified for bloom");
    }

    @Override
    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public String getFluidName() {
        return this.fluidName;
    }

    public boolean hasState() {
        return this.state != null && !this.state.isEmpty();
    }
}

