/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.lowdragmc.shimmer.config.Check;
import com.lowdragmc.shimmer.config.KeyShared;
import com.lowdragmc.shimmer.config.Light;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.util.FastColor;
import org.apache.http.util.Asserts;

public class ColorReferences
extends KeyShared
implements Check {
    Object2IntMap<String> namedIntColorMap;
    Map<String, Consumer<Light>> colors;
    private static final String colorReferencesNameRegex = "\\w+";

    public void init() {
        this.namedIntColorMap = this.namedIntColorMap == null ? Object2IntMaps.emptyMap() : Object2IntMaps.unmodifiable(this.namedIntColorMap);
        this.colors = this.namedIntColorMap.object2IntEntrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, stringEntry -> {
            int intColor = stringEntry.getIntValue();
            int r = FastColor.ARGB32.m_13665_((int)intColor);
            int g = FastColor.ARGB32.m_13667_((int)intColor);
            int b = FastColor.ARGB32.m_13669_((int)intColor);
            int a = FastColor.ARGB32.m_13655_((int)intColor);
            return light -> {
                light.setR(r);
                light.setG(g);
                light.setB(b);
                light.setAlpha(a);
            };
        }));
    }

    public void analyzeReferenceColor(Light light) {
        String color = light.getColorReference();
        if (color == null) {
            return;
        }
        Consumer<Light> setLightColorFunction = this.colors.get(color);
        setLightColorFunction.accept(light);
    }

    @Override
    public void check() {
    }

    public void checkLight(Light light) {
        String colorReference = light.getColorReference();
        if (colorReference != null) {
            Objects.requireNonNull(this.colors.get(colorReference), MessageFormat.format("can't find color reference called {0}", colorReference));
        }
    }

    public static void assertHexColorReferenceFormat(String color) {
        Objects.requireNonNull(color, "color reference for hex can't be null");
        Asserts.check((color.length() == 9 ? 1 : 0) != 0, (String)"color reference for hex must be formatted in hex #RRGGBBAA");
        Asserts.check((boolean)Objects.equals(Character.valueOf(color.charAt(0)), Character.valueOf('#')), (String)"the first char of color references must be #");
        Asserts.check((boolean)color.substring(1).chars().allMatch(c -> c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70), (String)"color reference can only contain 0-9 a-f A-F");
    }

    public static void assertColorName(String colorName) {
        Asserts.check((boolean)colorName.matches(colorReferencesNameRegex), (String)("color reference " + colorName + " not match \\w+"));
    }
}

