/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.lowdragmc.shimmer.config.ColorReferences;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.IOException;
import net.minecraft.util.FastColor;
import org.apache.http.util.Asserts;

public class ColorReferencesTypeAdapter
extends TypeAdapter<ColorReferences> {
    public void write(JsonWriter out, ColorReferences colorReferences) throws IOException {
        out.beginObject();
        colorReferences.namedIntColorMap.object2IntEntrySet().forEach(entry -> {
            String colorName = (String)entry.getKey();
            int color = entry.getIntValue();
            String r = Integer.toHexString(FastColor.ARGB32.m_13665_((int)color));
            String g = Integer.toHexString(FastColor.ARGB32.m_13667_((int)color));
            String b = Integer.toHexString(FastColor.ARGB32.m_13669_((int)color));
            String a = Integer.toHexString(FastColor.ARGB32.m_13655_((int)color));
            String colorString = "#" + r + g + b + a;
            try {
                out.name(colorName);
                out.value(colorString);
            }
            catch (IOException e) {
                throw new RuntimeException("color name:" + colorName + ",color value:" + colorString, e);
            }
        });
        out.endObject();
    }

    public ColorReferences read(JsonReader in) throws IOException {
        ColorReferences colorReference = new ColorReferences();
        colorReference.namedIntColorMap = new Object2IntArrayMap();
        in.beginObject();
        block20: while (in.hasNext()) {
            String colorName = in.nextName();
            ColorReferences.assertColorName(colorName);
            switch (in.peek()) {
                case BEGIN_OBJECT: {
                    in.beginObject();
                    int r = -1;
                    int g = -1;
                    int b = -1;
                    int a = -1;
                    block21: while (in.peek() != JsonToken.END_OBJECT) {
                        String colorTypeName;
                        switch (colorTypeName = in.nextName()) {
                            case "r": 
                            case "red": {
                                if (r == -1) {
                                    r = in.nextInt();
                                    Asserts.check((r >= 0 && r <= 255 ? 1 : 0) != 0, (String)"r must range in [0-255]");
                                    continue block21;
                                }
                                throw new RuntimeException("can't set r for multi time");
                            }
                            case "g": 
                            case "green": {
                                if (g == -1) {
                                    g = in.nextInt();
                                    Asserts.check((g >= 0 && g <= 255 ? 1 : 0) != 0, (String)"g must range in [0-255]");
                                    continue block21;
                                }
                                throw new RuntimeException("can't set rg for multi time");
                            }
                            case "b": 
                            case "blue": {
                                if (b == -1) {
                                    b = in.nextInt();
                                    Asserts.check((b >= 0 && b <= 255 ? 1 : 0) != 0, (String)"b must range in [0-255]");
                                    continue block21;
                                }
                                throw new RuntimeException("can't set r for multi time");
                            }
                            case "a": 
                            case "alpha": {
                                if (a == -1) {
                                    a = in.nextInt();
                                    Asserts.check((a >= 0 && a <= 255 ? 1 : 0) != 0, (String)"a must range in [0-255]");
                                    continue block21;
                                }
                                throw new RuntimeException("can't set a for multi time");
                            }
                        }
                        throw new RuntimeException("unknown colorTypeName " + colorTypeName);
                    }
                    in.endObject();
                    colorReference.namedIntColorMap.put((Object)colorName, FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b));
                    continue block20;
                }
                case STRING: {
                    String color = in.nextString();
                    ColorReferences.assertHexColorReferenceFormat(color);
                    int intColor = Integer.parseInt(color.substring(1, 9), 16);
                    int r = intColor >> 24 & 0xFF;
                    int g = intColor >> 16 & 0xFF;
                    int b = intColor >> 8 & 0xFF;
                    int a = intColor & 0xFF;
                    colorReference.namedIntColorMap.put((Object)colorName, FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b));
                    continue block20;
                }
            }
            throw new RuntimeException("unexpected json token " + in.peek());
        }
        in.endObject();
        return colorReference;
    }
}

