/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.google.gson.annotations.SerializedName;
import com.lowdragmc.shimmer.config.Check;
import com.lowdragmc.shimmer.config.ColorReferences;
import com.lowdragmc.shimmer.config.KeyShared;
import java.util.Objects;
import net.minecraft.util.FastColor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;

class Light
extends KeyShared
implements Check {
    @SerializedName(value="r", alternate={"red"})
    private int r;
    @SerializedName(value="g", alternate={"green"})
    private int g;
    @SerializedName(value="b", alternate={"blue"})
    private int b;
    @SerializedName(value="a", alternate={"alpha"})
    public int alpha = 255;
    public float radius;
    private String color;

    Light() {
    }

    public int color() {
        return FastColor.ARGB32.m_13660_((int)this.alpha, (int)this.r, (int)this.g, (int)this.b);
    }

    @Override
    public void check() {
        if (this.color != null) {
            Asserts.check((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.color}), (String)"color reference can't be blank or null");
            Asserts.check((this.color.length() >= 2 ? 1 : 0) != 0, (String)"color reference must formatted in #referenceName");
            Asserts.check((boolean)Objects.equals(Character.valueOf(this.color.charAt(0)), Character.valueOf('#')), (String)"color reference usage must begin with #");
            this.color = this.color.substring(1);
            ColorReferences.assertColorName(this.color);
        } else {
            Asserts.check((this.r <= 255 && this.r >= 0 ? 1 : 0) != 0, (String)"red must range in [0,255] for Light");
            Asserts.check((this.g <= 255 && this.g >= 0 ? 1 : 0) != 0, (String)"greed must range in [0,255] for Light");
            Asserts.check((this.b <= 255 && this.b >= 0 ? 1 : 0) != 0, (String)"blue must range in [0,255] for Light");
            Asserts.check((this.alpha <= 255 && this.alpha >= 0 ? 1 : 0) != 0, (String)"alpha must range in [0,255] for Light");
            Asserts.check((this.radius >= 0.0f && this.radius <= 15.0f ? 1 : 0) != 0, (String)"radius must range in [1,15] for Light");
        }
    }

    public void setRGB(int rgb) {
        this.r = FastColor.ARGB32.m_13665_((int)rgb);
        this.g = FastColor.ARGB32.m_13667_((int)rgb);
        this.b = FastColor.ARGB32.m_13669_((int)rgb);
    }

    public String getColorReference() {
        return this.color;
    }

    public void setR(int r) {
        this.r = r;
    }

    public void setG(int g) {
        this.g = g;
    }

    public void setB(int b) {
        this.b = b;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

