/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.config;

import com.google.gson.annotations.SerializedName;
import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.config.BlockLight;
import com.lowdragmc.shimmer.config.Bloom;
import com.lowdragmc.shimmer.config.Check;
import com.lowdragmc.shimmer.config.ColorReferences;
import com.lowdragmc.shimmer.config.ItemLight;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class ShimmerConfig {
    @SerializedName(value="Enable")
    public AtomicBoolean enable;
    @SerializedName(value="ConfigSource")
    public transient String configSource;
    @SerializedName(value="LightBlock")
    public List<BlockLight> blockLights;
    @SerializedName(value="LightItem")
    public List<ItemLight> itemLights;
    @SerializedName(value="Bloom")
    public List<Bloom> blooms;
    @SerializedName(value="ColorReference")
    public ColorReferences colorReferences;

    public void init() {
        if (this.blockLights == null) {
            this.blockLights = new ArrayList<BlockLight>();
        }
        if (this.itemLights == null) {
            this.itemLights = new ArrayList<ItemLight>();
        }
        if (this.blooms == null) {
            this.blooms = new ArrayList<Bloom>();
        }
        if (this.colorReferences == null) {
            this.colorReferences = new ColorReferences();
        }
        this.colorReferences.init();
        if (this.enable == null) {
            this.enable = new AtomicBoolean(true);
        }
        this.blockLights.forEach(i -> {
            i.shimmerConfig = this;
        });
        this.itemLights.forEach(i -> {
            i.shimmerConfig = this;
        });
        this.blooms.forEach(i -> {
            i.shimmerConfig = this;
        });
        this.colorReferences.shimmerConfig = this;
        if (this.configSource == null) {
            this.configSource = "Unknown";
        }
    }

    public boolean check(String message) {
        ArrayList errors = new ArrayList();
        this.configSource = message;
        this.init();
        if (this.blockLights.isEmpty() && this.itemLights.isEmpty() && this.blooms.isEmpty()) {
            ShimmerConstants.LOGGER.error("find empty config " + message);
            return false;
        }
        this.blockLights.forEach(i -> ShimmerConfig.checkItem(i, errors));
        this.itemLights.forEach(i -> ShimmerConfig.checkItem(i, errors));
        this.blooms.forEach(i -> ShimmerConfig.checkItem(i, errors));
        this.blockLights.forEach(this.colorReferences::checkLight);
        this.itemLights.forEach(this.colorReferences::checkLight);
        this.apply();
        if (errors.isEmpty()) {
            return true;
        }
        ShimmerConstants.LOGGER.error("detect error from " + message);
        errors.forEach(arg_0 -> ((Logger)ShimmerConstants.LOGGER).error(arg_0));
        return false;
    }

    private void apply() {
        this.blockLights.forEach(this.colorReferences::analyzeReferenceColor);
        this.itemLights.forEach(this.colorReferences::analyzeReferenceColor);
    }

    private static <T extends Check> void checkItem(T item, List<String> errors) {
        try {
            item.check();
        }
        catch (Exception e) {
            errors.add(e.getMessage());
        }
    }
}

