/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.core.mixins;

import com.lowdragmc.shimmer.client.ShimmerRenderTypes;
import com.lowdragmc.shimmer.client.auxiliaryScreen.Eyedropper;
import com.lowdragmc.shimmer.client.auxiliaryScreen.HsbColorWidget;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.lowdragmc.shimmer.client.shader.ShaderSSBO;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Map<String, ShaderInstance> f_172578_;
    @Shadow
    @Final
    private ResourceManager f_109060_;

    @Shadow
    public abstract void m_172736_(boolean var1);

    @Inject(method={"resize"}, at={@At(value="RETURN")})
    private void injectResize(int width, int height, CallbackInfo ci) {
        PostProcessing.resize(width, height);
    }

    @Inject(method={"reloadShaders"}, at={@At(value="RETURN")})
    private void injectReloadShaders(ResourceManager pResourceManager, CallbackInfo ci) {
        if (Services.PLATFORM.isLoadingStateValid()) {
            LightManager.INSTANCE.reloadShaders();
        }
    }

    @Inject(method={"reloadShaders"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;shutdownShaders()V", shift=At.Shift.AFTER)})
    private void reloadShaders(ResourceManager resourceManager, CallbackInfo ci) {
        if (Services.PLATFORM.getPlatformName().equalsIgnoreCase("fabric")) {
            this.setupShader(RenderUtils::registerShaders, resourceManager);
            this.setupShader(ShimmerRenderTypes::registerShaders, resourceManager);
            this.setupShader(HsbColorWidget::registerShaders, resourceManager);
            if (ShaderSSBO.support()) {
                this.setupShader(Eyedropper::registerShaders, resourceManager);
            }
        }
    }

    private void setupShader(Function<ResourceManager, Pair<ShaderInstance, Consumer<ShaderInstance>>> function, ResourceManager manager) {
        Pair<ShaderInstance, Consumer<ShaderInstance>> shader = function.apply(manager);
        this.f_172578_.put(((ShaderInstance)shader.getFirst()).m_173365_(), (ShaderInstance)shader.getFirst());
        ((Consumer)shader.getSecond()).accept((ShaderInstance)shader.getFirst());
    }
}

