/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.core.mixins;

import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.client.shader.ReloadShaderManager;
import com.lowdragmc.shimmer.core.IRenderChunk;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL30;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private ObjectArrayList<LevelRenderer.RenderChunkInfo> f_194297_;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;constantAmbientLight()Z")})
    private void injectRenderLevel(PoseStack poseStack, float pPartialTick, long pFinishNanoTime, boolean pRenderBlockOutline, Camera camera, GameRenderer pGameRenderer, LightTexture pLightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        this.f_109465_.m_46473_().m_6182_("block_bloom");
        PostProcessing.getBlockBloom().renderBlockPost();
    }

    @Inject(method={"renderChunkLayer"}, at={@At(value="HEAD")})
    private void preRenderChunkLayer(RenderType pRenderType, PoseStack pPoseStack, double pCamX, double pCamY, double pCamZ, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        if (PostProcessing.CHUNK_TYPES.contains(pRenderType)) {
            GL30.glDrawBuffers((int[])new int[]{36064, Services.PLATFORM.getBloomColorAttachmentNumber()});
        }
    }

    @Inject(method={"renderChunkLayer"}, at={@At(value="RETURN")})
    private void postRenderChunkLayer(RenderType pRenderType, PoseStack pPoseStack, double pCamX, double pCamY, double pCamZ, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        if (PostProcessing.CHUNK_TYPES.contains(pRenderType)) {
            GL30.glDrawBuffers((int)36064);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=1)})
    private void injectRenderLevelBloom(PoseStack poseStack, float pPartialTick, long pFinishNanoTime, boolean pRenderBlockOutline, Camera camera, GameRenderer pGameRenderer, LightTexture pLightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        ProfilerFiller profilerFiller = this.f_109465_.m_46473_();
        for (PostProcessing postProcessing : PostProcessing.values()) {
            postProcessing.renderEntityPost(profilerFiller);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void injectRenderLevelPre(PoseStack pPoseStack, float pPartialTick, long pFinishNanoTime, boolean pRenderBlockOutline, Camera pCamera, GameRenderer pGameRenderer, LightTexture pLightTexture, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        Vec3 position = pCamera.m_90583_();
        int blockLightSize = 0;
        int left = LightManager.INSTANCE.leftBlockLightCount();
        FloatBuffer buffer = LightManager.INSTANCE.getBuffer();
        buffer.clear();
        block0: for (LevelRenderer.RenderChunkInfo chunkInfo : this.f_194297_) {
            if (left <= blockLightSize) break;
            if (!(chunkInfo.f_109839_ instanceof IRenderChunk)) continue;
            for (ColorPointLight shimmerLight : ((IRenderChunk)chunkInfo.f_109839_).getShimmerLights()) {
                if (left <= blockLightSize) continue block0;
                shimmerLight.uploadBuffer(buffer);
                ++blockLightSize;
            }
        }
        LightManager.INSTANCE.renderLevelPre(blockLightSize, (float)position.f_82479_, (float)position.f_82480_, (float)position.f_82481_);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void injectRenderLevelPost(PoseStack pPoseStack, float pPartialTick, long pFinishNanoTime, boolean pRenderBlockOutline, Camera pCamera, GameRenderer pGameRenderer, LightTexture pLightTexture, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        LightManager.INSTANCE.renderLevelPost();
    }

    @Redirect(method={"initOutline"}, at=@At(value="NEW", target="(Lnet/minecraft/client/renderer/texture/TextureManager;Lnet/minecraft/server/packs/resources/ResourceManager;Lcom/mojang/blaze3d/pipeline/RenderTarget;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/PostChain;"))
    private PostChain redirectInitOutline(TextureManager textureManager, ResourceManager resourceManager, RenderTarget renderTarget, ResourceLocation resourceLocation) throws IOException {
        return ReloadShaderManager.backupNewPostChain(textureManager, resourceManager, renderTarget, resourceLocation);
    }

    @Redirect(method={"initTransparency"}, at=@At(value="NEW", target="(Lnet/minecraft/client/renderer/texture/TextureManager;Lnet/minecraft/server/packs/resources/ResourceManager;Lcom/mojang/blaze3d/pipeline/RenderTarget;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/PostChain;"))
    private PostChain redirectInitTransparency(TextureManager textureManager, ResourceManager resourceManager, RenderTarget renderTarget, ResourceLocation resourceLocation) throws IOException {
        return ReloadShaderManager.backupNewPostChain(textureManager, resourceManager, renderTarget, resourceLocation);
    }
}

