/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.client.shader.ShaderInjection;
import com.lowdragmc.shimmer.core.IGlslProcessor;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Program.class})
public abstract class ProgramMixin {
    @Shadow
    @Final
    private Program.Type f_85535_;
    private static final Pattern REGEX_VERSION = Pattern.compile("(#(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*version(?:/\\*(?:[^*]|\\*+[^*/])*\\*+/|\\h)*(\\d+))\\b");

    @ModifyExpressionValue(method={"compileShaderInternal"}, at={@At(value="INVOKE", target="Lorg/apache/commons/io/IOUtils;toString(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/lang/String;")})
    private static String transformShader(String shader, Program.Type type, String shaderName, InputStream pShaderDataSame, String pShaderSourceName, GlslPreprocessor processor) {
        String injectedShader;
        boolean isVsh;
        if (Services.PLATFORM.isEnableInsetShaderInfo()) {
            Matcher matcher = REGEX_VERSION.matcher(shader);
            int index = matcher.find() ? matcher.group().length() : 0;
            shader = pShaderSourceName.equals("Mod Resources") || pShaderSourceName.equals("Default") ? new StringBuilder(shader).insert(index, "\n#line __LINE__ //shaderName:" + shaderName).toString() : new StringBuilder(shader).insert(index, "\n#line __LINE__ //ShaderSourceName:" + pShaderSourceName).toString();
        }
        boolean bl = isVsh = type == Program.Type.VERTEX;
        if (isVsh && ShaderInjection.hasInjectVSH(shaderName)) {
            injectedShader = ShaderInjection.injectVSH(shaderName, shader);
        } else if (type == Program.Type.FRAGMENT && ShaderInjection.hasInjectFSH(shaderName)) {
            injectedShader = ShaderInjection.injectFSH(shaderName, shader);
        } else {
            return shader;
        }
        int testShaderId = GlStateManager.m_84447_((int)(type == Program.Type.VERTEX ? 35633 : 35632));
        GlStateManager.m_157116_((int)testShaderId, (List)processor.m_166461_(injectedShader));
        GlStateManager.m_84465_((int)testShaderId);
        if (GlStateManager.m_84449_((int)testShaderId, (int)35713) == 0) {
            GlStateManager.m_84421_((int)testShaderId);
            String errorInfo = StringUtils.trim((String)GlStateManager.m_84492_((int)testShaderId, (int)Short.MAX_VALUE));
            ShimmerConstants.LOGGER.error("Couldn't compile {} program({},{}):{}", (Object)type.name(), (Object)pShaderSourceName, (Object)shaderName, (Object)errorInfo);
            return shader;
        }
        if (processor instanceof IGlslProcessor) {
            IGlslProcessor iGlslProcessor = (IGlslProcessor)processor;
            iGlslProcessor.clearImportedPathRecord();
        }
        GlStateManager.m_84421_((int)testShaderId);
        return injectedShader;
    }
}

