/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.core.mixins;

import com.google.common.collect.ImmutableList;
import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.core.IRenderChunk;
import java.util.List;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkRenderDispatcher.RenderChunk.RebuildTask.class})
public abstract class RebuildTaskMixin {
    @Shadow(aliases={"this$1", "f_112859_", "field_20839"})
    @Final
    ChunkRenderDispatcher.RenderChunk this$1;
    ImmutableList.Builder<ColorPointLight> lights;

    @Redirect(method={"compile"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/RenderChunkRegion;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0))
    private BlockState injectCompile(RenderChunkRegion instance, BlockPos pPos) {
        ColorPointLight light;
        BlockState blockstate = instance.m_8055_(pPos);
        FluidState fluidstate = blockstate.m_60819_();
        if (LightManager.INSTANCE.isBlockHasLight(blockstate.m_60734_(), fluidstate) && (light = LightManager.INSTANCE.getBlockStateLight((BlockAndTintGetter)instance, pPos, blockstate, fluidstate)) != null) {
            this.lights.add((Object)light);
        }
        PostProcessing.setupBloom(blockstate, fluidstate);
        return blockstate;
    }

    @Inject(method={"compile"}, at={@At(value="HEAD")})
    private void injectCompilePre(float x, float y, float z, ChunkBufferBuilderPack arg, CallbackInfoReturnable<ChunkRenderDispatcher.RenderChunk.RebuildTask.CompileResults> cir) {
        this.lights = ImmutableList.builder();
    }

    @Inject(method={"compile"}, at={@At(value="RETURN")})
    private void injectCompilePost(float x, float y, float z, ChunkBufferBuilderPack arg, CallbackInfoReturnable<ChunkRenderDispatcher.RenderChunk.RebuildTask.CompileResults> cir) {
        if (this.this$1 instanceof IRenderChunk) {
            ((IRenderChunk)this.this$1).setShimmerLights((List<ColorPointLight>)this.lights.build());
        }
        PostProcessing.cleanBloom();
    }
}

