/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.forge.client;

import com.lowdragmc.shimmer.Utils;
import com.lowdragmc.shimmer.client.auxiliaryScreen.AuxiliaryScreen;
import com.lowdragmc.shimmer.client.auxiliaryScreen.Eyedropper;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.client.shader.ReloadShaderManager;
import com.lowdragmc.shimmer.forge.ForgeShimmerConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="shimmer", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ForgeEventListener {
    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() == Minecraft.m_91087_().f_91073_) {
            LightManager.clear();
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shimmer").then(Commands.m_82127_((String)"reload_postprocessing").executes(context -> {
            for (PostProcessing post : PostProcessing.values()) {
                post.m_6213_(null);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"clear_lights").executes(context -> {
            LightManager.clear();
            return 1;
        }))).then(Commands.m_82127_((String)"reload_shader").executes(context -> {
            ReloadShaderManager.reloadShader();
            return 1;
        }))).then(Commands.m_82127_((String)"confirm_clear_resource").executes(context -> {
            ReloadShaderManager.cleanResource();
            return 1;
        }))).then(Commands.m_82127_((String)"colored_light").then(Commands.m_82129_((String)"switch_state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ForgeShimmerConfig.getColoredLightEnable().set((Object)((Boolean)context.getArgument("switch_state", Boolean.class)));
            return 1;
        })))).then(Commands.m_82127_((String)"bloom").then(Commands.m_82129_((String)"switch_state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ForgeShimmerConfig.getBloomEnable().set((Object)((Boolean)context.getArgument("switch_state", Boolean.class)));
            return 1;
        })))).then(Commands.m_82127_((String)"additive_blend").then(Commands.m_82129_((String)"switch_state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ForgeShimmerConfig.getAdditiveBlend().set((Object)((Boolean)context.getArgument("switch_state", Boolean.class)));
            ReloadShaderManager.reloadShader();
            return 1;
        })))).then(Commands.m_82127_((String)"auxiliary_screen").executes(context -> {
            Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().m_91152_((Screen)new AuxiliaryScreen()));
            return 1;
        }))).then(Commands.m_82127_((String)"eyedropper").executes(context -> {
            if (Eyedropper.getState()) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"exit eyedropper mode"));
            } else {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("enter eyedropper mode, backend: " + Eyedropper.mode.modeName())));
            }
            Eyedropper.switchState();
            return 1;
        }))).then(Commands.m_82127_((String)"eyedropper").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"backend").then(Commands.m_82127_((String)"ShaderStorageBufferObject").executes(context -> {
            Eyedropper.switchMode(Eyedropper.ShaderStorageBufferObject);
            return 1;
        }))).then(Commands.m_82127_((String)"glGetTexImage").executes(context -> {
            Eyedropper.switchMode(Eyedropper.DOWNLOAD);
            return 1;
        }))))).then(Commands.m_82127_((String)"dumpLightBlockStates").executes(context -> {
            if (Utils.dumpAllLightingBlocks()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"dump successfully to cfg/shimmer/LightBlocks.txt"), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"dump failed, see log for detailed information"));
            }
            return 1;
        })));
    }
}

