/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.forge.core.mixins;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.lowdragmc.shimmer.TracedGLState;
import com.lowdragmc.shimmer.client.postprocessing.IPostParticleType;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.core.IParticleDescription;
import com.lowdragmc.shimmer.core.IParticleEngine;
import com.lowdragmc.shimmer.core.mixins.LightTextureAccessor;
import com.lowdragmc.shimmer.core.mixins.ShimmerMixinPlugin;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ParticleEngine.class})
public abstract class ForgeParticleEngineMixin
implements IParticleEngine {
    @Shadow
    @Final
    private Map<ParticleRenderType, Queue<Particle>> f_107289_;
    private final Map<ResourceLocation, String> PARTICLE_EFFECT = Maps.newHashMap();

    @Shadow
    @Nullable
    protected abstract <T extends ParticleOptions> Particle m_107395_(T var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @Shadow
    public abstract void m_107344_(Particle var1);

    @Override
    @Nullable
    public Particle createPostParticle(PostProcessing postProcessing, ParticleOptions pParticleData, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        Particle particle = this.m_107395_(pParticleData, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        if (particle != null) {
            particle = Services.PLATFORM.createPostParticle(particle, postProcessing);
            this.m_107344_(particle);
            return particle;
        }
        return null;
    }

    @ModifyReceiver(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleRenderType;begin(Lcom/mojang/blaze3d/vertex/BufferBuilder;Lnet/minecraft/client/renderer/texture/TextureManager;)V")})
    private ParticleRenderType injectRenderPre(ParticleRenderType particlerendertype, BufferBuilder bufferBuilder, TextureManager textureManager) {
        if (particlerendertype instanceof IPostParticleType && this.f_107289_.get(particlerendertype).size() > 0) {
            PostProcessing postProcessing = ((IPostParticleType)particlerendertype).getPost();
            postProcessing.getPostTarget(false).m_83947_(false);
            postProcessing.hasParticle();
            this.shimmer$turnOnLightTextureIfNeeded();
        }
        return particlerendertype;
    }

    @Unique
    private void shimmer$turnOnLightTextureIfNeeded() {
        LightTexture lightTexture;
        int lightTextureID;
        int currentLightTextureSlotID = RenderSystem.m_157203_((int)2);
        if (currentLightTextureSlotID != (lightTextureID = ((LightTextureAccessor)(lightTexture = Minecraft.m_91087_().f_91063_.m_109154_())).getLightTexture().m_117963_())) {
            lightTexture.m_109896_();
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleRenderType;end(Lcom/mojang/blaze3d/vertex/Tesselator;)V", shift=At.Shift.AFTER)})
    private void injectRenderPost(CallbackInfo ci) {
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        if (TracedGLState.bindFrameBuffer != mainRenderTarget.f_83920_) {
            mainRenderTarget.m_83947_(false);
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;)V"}, at={@At(value="RETURN")}, remap=false)
    private void injectRenderReturn(PoseStack pMatrixStack, MultiBufferSource.BufferSource pBuffer, LightTexture pLightTexture, Camera pActiveRenderInfo, float pPartialTicks, Frustum clippingHelper, CallbackInfo ci) {
        for (PostProcessing postProcessing : PostProcessing.values()) {
            postProcessing.renderParticlePost();
        }
    }

    @ModifyExpressionValue(method={"loadParticleDescription"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleDescription;fromJson(Lcom/google/gson/JsonObject;)Lnet/minecraft/client/particle/ParticleDescription;")})
    private ParticleDescription injectLoad(ParticleDescription particleDescription, ResourceManager manager, ResourceLocation registryName) {
        IParticleDescription description;
        if (particleDescription instanceof IParticleDescription && (description = (IParticleDescription)particleDescription).getEffect() != null) {
            this.PARTICLE_EFFECT.put(registryName, description.getEffect());
        }
        return particleDescription;
    }

    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void injectReload(PreparableReloadListener.PreparationBarrier $$0, ResourceManager $$1, ProfilerFiller $$2, ProfilerFiller $$3, Executor $$4, Executor $$5, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        this.PARTICLE_EFFECT.clear();
    }

    @Inject(method={"createParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCreateParticle(ParticleOptions particleOptions, double x, double y, double z, double sx, double sy, double sz, CallbackInfoReturnable<Particle> cir) {
        ResourceLocation name = Registry.f_122829_.m_7981_((Object)particleOptions.m_6012_());
        if (!ShimmerMixinPlugin.IS_OPT_LOAD) {
            if (this.PARTICLE_EFFECT.containsKey(name)) {
                PostProcessing postProcessing = PostProcessing.getPost(this.PARTICLE_EFFECT.get(name));
                if (postProcessing != null) {
                    cir.setReturnValue((Object)this.createPostParticle(postProcessing, particleOptions, x, y, z, sx, sy, sz));
                }
            } else if (PostProcessing.BLOOM_PARTICLE.contains(name)) {
                cir.setReturnValue((Object)this.createPostParticle(PostProcessing.getBlockBloom(), particleOptions, x, y, z, sx, sy, sz));
            }
        }
    }
}

