/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.forge.core.mixins.rubidium;

import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.core.IRenderChunk;
import com.lowdragmc.shimmer.forge.core.mixins.rubidium.RenderSectionManagerAccessor;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.util.frustum.Frustum;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumWorldRenderer.class})
public abstract class SodiumWorldRendererMixin {
    @Shadow(remap=false)
    private RenderSectionManager renderSectionManager;

    @Inject(method={"updateChunks"}, at={@At(value="RETURN")}, remap=false)
    private void injectCompilePre(Camera camera, Frustum frustum, int frame, boolean spectator, CallbackInfo ci) {
        Vec3 position = camera.m_90583_();
        int blockLightSize = 0;
        int left = LightManager.INSTANCE.leftBlockLightCount();
        FloatBuffer buffer = LightManager.INSTANCE.getBuffer();
        buffer.clear();
        ChunkRenderList chunkRenderList = ((RenderSectionManagerAccessor)this.renderSectionManager).getChunkRenderList();
        block0: for (Map.Entry entry : chunkRenderList.sorted(false)) {
            if (left <= blockLightSize) break;
            List regionSections = (List)entry.getValue();
            block1: for (RenderSection regionSection : regionSections) {
                if (left <= blockLightSize) continue block0;
                if (!(regionSection instanceof IRenderChunk)) continue;
                IRenderChunk renderChunk = (IRenderChunk)regionSection;
                for (ColorPointLight shimmerLight : renderChunk.getShimmerLights()) {
                    if (left <= blockLightSize) continue block1;
                    shimmerLight.uploadBuffer(buffer);
                    ++blockLightSize;
                }
            }
        }
        LightManager.INSTANCE.renderLevelPre(blockLightSize, (float)position.f_82479_, (float)position.f_82480_, (float)position.f_82481_);
    }
}

