/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.forge.platform;

import com.lowdragmc.shimmer.client.postprocessing.PostParticle;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.event.ShimmerLoadConfigEvent;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.forge.ForgeShimmerConfig;
import com.lowdragmc.shimmer.forge.event.ForgeShimmerLoadConfigEvent;
import com.lowdragmc.shimmer.forge.event.ForgeShimmerReloadEvent;
import com.lowdragmc.shimmer.platform.services.IPlatformHelper;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.lwjgl.opengl.GL11;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public List<String> getLoadedMods() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isStencilEnabled(RenderTarget target) {
        return target.isStencilEnabled();
    }

    @Override
    public boolean useCombinedDepthStencilAttachment() {
        return (Boolean)ForgeConfig.CLIENT.useCombinedDepthStencilAttachment.get();
    }

    @Override
    public void enableStencil(RenderTarget renderTarget) {
        renderTarget.enableStencil();
    }

    @Override
    public int getUniformBufferObjectOffset() {
        int configValue = (Integer)ForgeShimmerConfig.getUboOffset().get();
        if (configValue == -1) {
            if (ModList.get().isLoaded("modernui")) {
                return 6;
            }
            return 1;
        }
        return Mth.m_14045_((int)configValue, (int)0, (int)(GL11.glGetInteger((int)35375) - 1));
    }

    @Override
    public boolean useBlockBloom() {
        return (Boolean)ForgeShimmerConfig.getBlockBloom().get();
    }

    @Override
    public boolean useLightMap() {
        return (Boolean)ForgeShimmerConfig.getLightMap().get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PostParticle createPostParticle(Particle parent, PostProcessing postProcessing) {
        return new PostParticle(parent, postProcessing){

            public boolean shouldCull() {
                return this.parent.shouldCull();
            }
        };
    }

    @Override
    public boolean isLoadingStateValid() {
        return ModLoader.isLoadingStateValid();
    }

    @Override
    public boolean isColoredLightEnable() {
        return (Boolean)ForgeShimmerConfig.getColoredLightEnable().get();
    }

    @Override
    public boolean isBloomEnable() {
        return (Boolean)ForgeShimmerConfig.getBloomEnable().get();
    }

    @Override
    public boolean isAdditiveBlend() {
        return (Boolean)ForgeShimmerConfig.getAdditiveBlend().get();
    }

    @Override
    public ShimmerLoadConfigEvent postLoadConfigurationEvent(ShimmerLoadConfigEvent event) {
        ModLoader.get().postEvent((Event)new ForgeShimmerLoadConfigEvent(event));
        return event;
    }

    @Override
    public ShimmerReloadEvent postReloadEvent(ShimmerReloadEvent event) {
        ModLoader.get().postEvent((Event)new ForgeShimmerReloadEvent(event));
        return event;
    }

    @Override
    public int getBloomColorAttachmentNumber() {
        return 36065;
    }

    @Override
    public boolean isEnableInsetShaderInfo() {
        return this.isDevelopmentEnvironment();
    }

    @Override
    public ResourceLocation getFluidTextureLocation(Fluid fluid, boolean isStill) {
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        return isStill ? fluidTypeExtensions.getStillTexture() : fluidTypeExtensions.getFlowingTexture();
    }

    @Override
    public int getFluidColor(Fluid fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }
}

