/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.platform.services;

import com.lowdragmc.shimmer.client.postprocessing.PostParticle;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.event.ShimmerLoadConfigEvent;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public List<String> getLoadedMods();

    public boolean isDevelopmentEnvironment();

    public boolean isStencilEnabled(RenderTarget var1);

    public boolean useCombinedDepthStencilAttachment();

    public void enableStencil(RenderTarget var1);

    public int getUniformBufferObjectOffset();

    public boolean useBlockBloom();

    public boolean useLightMap();

    default public PostParticle createPostParticle(Particle parent, PostProcessing postProcessing) {
        return new PostParticle(parent, postProcessing);
    }

    default public boolean isLoadingStateValid() {
        return true;
    }

    public boolean isColoredLightEnable();

    public boolean isBloomEnable();

    public boolean isAdditiveBlend();

    public ShimmerLoadConfigEvent postLoadConfigurationEvent(ShimmerLoadConfigEvent var1);

    public ShimmerReloadEvent postReloadEvent(ShimmerReloadEvent var1);

    public int getBloomColorAttachmentNumber();

    public boolean isEnableInsetShaderInfo();

    public ResourceLocation getFluidTextureLocation(Fluid var1, boolean var2);

    public int getFluidColor(Fluid var1);

    public Path getConfigDir();
}

