/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.backpack.BambooBasketBackpack;
import com.mrcrayfish.backpacked.common.backpack.CardboardBoxBackpack;
import com.mrcrayfish.backpacked.common.backpack.ClassicBackpack;
import com.mrcrayfish.backpacked.common.backpack.CogwheelBackpack;
import com.mrcrayfish.backpacked.common.backpack.EndCrystalBackpack;
import com.mrcrayfish.backpacked.common.backpack.HoneyJarBackpack;
import com.mrcrayfish.backpacked.common.backpack.MiniChestBackpack;
import com.mrcrayfish.backpacked.common.backpack.PiglinPackBackpack;
import com.mrcrayfish.backpacked.common.backpack.RocketBackpack;
import com.mrcrayfish.backpacked.common.backpack.SheepPlushBackpack;
import com.mrcrayfish.backpacked.common.backpack.StandardBackpack;
import com.mrcrayfish.backpacked.common.backpack.TrashCanBackpack;
import com.mrcrayfish.backpacked.common.backpack.TurtleShellBackpack;
import com.mrcrayfish.backpacked.common.backpack.WanderingBagBackpack;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;

public class BackpackManager {
    private static BackpackManager instance;
    private final Map<ResourceLocation, Backpack> registeredBackpacks = new HashMap<ResourceLocation, Backpack>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
        this.register(new BambooBasketBackpack());
        this.register(new CardboardBoxBackpack());
        this.register(new ClassicBackpack());
        this.register(new EndCrystalBackpack());
        this.register(new HoneyJarBackpack());
        this.register(new MiniChestBackpack());
        this.register(new PiglinPackBackpack());
        this.register(new RocketBackpack());
        this.register(new SheepPlushBackpack());
        this.register(new StandardBackpack());
        this.register(new TrashCanBackpack());
        this.register(new TurtleShellBackpack());
        this.register(new WanderingBagBackpack());
        this.registerDependant("create", new CogwheelBackpack());
    }

    public synchronized void register(Backpack backpack) {
        this.registeredBackpacks.computeIfAbsent(backpack.getId(), location -> {
            MinecraftForge.EVENT_BUS.register((Object)backpack);
            return backpack;
        });
    }

    private synchronized void registerDependant(String mod, Backpack backpack) {
        if (!ModList.get().isLoaded(mod)) {
            return;
        }
        this.registeredBackpacks.computeIfAbsent(backpack.getId(), location -> {
            MinecraftForge.EVENT_BUS.register((Object)backpack);
            return backpack;
        });
    }

    public List<Backpack> getRegisteredBackpacks() {
        return ImmutableList.copyOf(this.registeredBackpacks.values());
    }

    public Backpack getBackpack(ResourceLocation id) {
        return this.registeredBackpacks.get(id);
    }

    public void unlockBackpack(ServerPlayer player, ResourceLocation id) {
        if (((Boolean)Config.SERVER.unlockAllBackpacks.get()).booleanValue()) {
            return;
        }
        if (this.registeredBackpacks.containsKey(id)) {
            UnlockTracker.get((Player)player).ifPresent(impl -> {
                if (impl.unlockBackpack(id)) {
                    Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUnlockBackpack(id));
                }
            });
        }
    }
}

