/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backpacked")
public class PickpocketChallenge {
    public static final Capability<PickpocketChallenge> PICKPOCKET_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PickpocketChallenge>(){});
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<Player, Long> detectedPlayers = new HashMap<Player, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
    }

    public Map<Player, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(Player player) {
        return this.dislikedPlayers.containsKey(player.m_20148_());
    }

    public void addDislikedPlayer(Player player, long time) {
        this.dislikedPlayers.put(player.m_20148_(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(PickpocketChallenge.class);
    }

    public static Optional<PickpocketChallenge> get(LivingEntity entity) {
        return entity.getCapability(PICKPOCKET_CAPABILITY).resolve();
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof WanderingTrader) {
            Provider provider = new Provider();
            event.addCapability(new ResourceLocation("backpacked", "pickpocket_challenge"), (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final PickpocketChallenge instance = new PickpocketChallenge();
        private final LazyOptional<PickpocketChallenge> optional = LazyOptional.of(() -> this.instance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PICKPOCKET_CAPABILITY.orEmpty(cap, this.optional.cast());
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Initialized", this.instance.initialized);
            tag.m_128379_("EquippedBackpack", this.instance.backpack);
            tag.m_128379_("SpawnedLoot", this.instance.spawnedLoot);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.instance.initialized = tag.m_128471_("Initialized");
            this.instance.backpack = tag.m_128471_("EquippedBackpack");
            this.instance.spawnedLoot = tag.m_128471_("SpawnedLoot");
        }

        public void invalidate() {
            this.optional.invalidate();
        }
    }
}

