/*
 * Decompiled with CFR 0.152.
 */
package forestry.api;

import forestry.api.ForestryConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class ForestryTags {

    public static class Fluids {
        public static final TagKey<Fluid> HONEY = Fluids.forgeTag("honey");

        private static TagKey<Fluid> forgeTag(String name) {
            return FluidTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> ARID_HUMIDITY = Biomes.tag("humidity/arid");
        public static final TagKey<Biome> NORMAL_HUMIDITY = Biomes.tag("humidity/normal");
        public static final TagKey<Biome> DAMP_HUMIDITY = Biomes.tag("humidity/damp");
        public static final TagKey<Biome> ICY_TEMPERATURE = Biomes.tag("temperature/icy");
        public static final TagKey<Biome> COLD_TEMPERATURE = Biomes.tag("temperature/cold");
        public static final TagKey<Biome> NORMAL_TEMPERATURE = Biomes.tag("temperature/normal");
        public static final TagKey<Biome> WARM_TEMPERATURE = Biomes.tag("temperature/warm");
        public static final TagKey<Biome> HOT_TEMPERATURE = Biomes.tag("temperature/hot");
        public static final TagKey<Biome> HELLISH_TEMPERATURE = Biomes.tag("temperature/hellish");
        public static final TagKey<Biome> SHATTERED_SAVANNA = Biomes.tag("special/shattered_savanna");

        private static TagKey<Biome> tag(String path) {
            return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)ForestryConstants.forestry(path));
        }
    }

    public static class Items {
        public static final TagKey<Item> CHARCOAL_BLOCK = Items.forgeTag("storage_blocks/charcoal");
        public static final TagKey<Item> VILLAGE_COMBS = Items.tag("village_combs");
        public static final TagKey<Item> BEE_COMBS = Items.tag("combs");
        public static final TagKey<Item> PROPOLIS = Items.tag("propolis");
        public static final TagKey<Item> DROP_HONEY = Items.tag("drop_honey");
        public static final TagKey<Item> INGOTS_BRONZE = Items.forgeTag("ingots/bronze");
        public static final TagKey<Item> INGOTS_TIN = Items.forgeTag("ingots/tin");
        public static final TagKey<Item> GEARS = Items.forgeTag("gears");
        public static final TagKey<Item> GEARS_BRONZE = Items.forgeTag("gears/bronze");
        public static final TagKey<Item> GEARS_COPPER = Items.forgeTag("gears/copper");
        public static final TagKey<Item> GEARS_TIN = Items.forgeTag("gears/tin");
        public static final TagKey<Item> GEARS_STONE = Items.forgeTag("gears/stone");
        public static final TagKey<Item> DUSTS_ASH = Items.forgeTag("dusts/ash");
        public static final TagKey<Item> SAWDUST = Items.forgeTag("sawdust");
        public static final TagKey<Item> GEMS_APATITE = Items.forgeTag("gems/apatite");
        public static final TagKey<Item> STORAGE_BLOCKS_APATITE = Items.forgeTag("storage_blocks/apatite");
        public static final TagKey<Item> STORAGE_BLOCKS_TIN = Items.forgeTag("storage_blocks/tin");
        public static final TagKey<Item> STORAGE_BLOCKS_BRONZE = Items.forgeTag("storage_blocks/bronze");
        public static final TagKey<Item> ORES_TIN = Items.forgeTag("ores/tin");
        public static final TagKey<Item> RAW_MATERIALS_TIN = Items.forgeTag("raw_materials/tin");
        public static final TagKey<Item> ORES_APATITE = Items.forgeTag("ores/apatite");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_TIN = Items.forgeTag("storage_blocks/raw_tin");
        public static final TagKey<Item> STAMPS = Items.tag("stamps");
        public static final TagKey<Item> SCOOPS = Items.tag("scoops");
        public static final TagKey<Item> FORESTRY_FRUITS = Items.tag("forestry_fruits");
        public static final TagKey<Item> FRUITS = Items.forgeTag("fruits");
        public static final TagKey<Item> CHERRY = Items.forgeTag("fruits/cherry");
        public static final TagKey<Item> WALNUT = Items.forgeTag("fruits/walnut");
        public static final TagKey<Item> CHESTNUT = Items.forgeTag("fruits/chestnut");
        public static final TagKey<Item> LEMON = Items.forgeTag("fruits/lemon");
        public static final TagKey<Item> PLUM = Items.forgeTag("fruits/plum");
        public static final TagKey<Item> DATE = Items.forgeTag("fruits/date");
        public static final TagKey<Item> PAPAYA = Items.forgeTag("fruits/papaya");
        public static final TagKey<Item> MINER_ALLOW = Items.tag("backpack/allow/miner");
        public static final TagKey<Item> MINER_REJECT = Items.tag("backpack/reject/miner");
        public static final TagKey<Item> DIGGER_ALLOW = Items.tag("backpack/allow/digger");
        public static final TagKey<Item> DIGGER_REJECT = Items.tag("backpack/reject/digger");
        public static final TagKey<Item> FORESTER_ALLOW = Items.tag("backpack/allow/forester");
        public static final TagKey<Item> FORESTER_REJECT = Items.tag("backpack/reject/forester");
        public static final TagKey<Item> ADVENTURER_ALLOW = Items.tag("backpack/allow/adventurer");
        public static final TagKey<Item> ADVENTURER_REJECT = Items.tag("backpack/reject/adventurer");
        public static final TagKey<Item> BUILDER_ALLOW = Items.tag("backpack/allow/builder");
        public static final TagKey<Item> BUILDER_REJECT = Items.tag("backpack/reject/builder");
        public static final TagKey<Item> HUNTER_ALLOW = Items.tag("backpack/allow/hunter");
        public static final TagKey<Item> HUNTER_REJECT = Items.tag("backpack/reject/hunter");
        public static final TagKey<Item> CRAFTING_TABLES = Items.tag("crafting_tables");
        public static final TagKey<Item> BEES = Items.tag("bees");

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)ForestryConstants.forestry(name));
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> MINEABLE_SCOOP = Blocks.tag("scoop");
        public static final TagKey<Block> MINEABLE_GRAFTER = Blocks.tag("grafter");
        public static final TagKey<Block> VALID_FARM_BASE = Blocks.tag("valid_farm_base");
        public static final TagKey<Block> CHARCOAL_BLOCK = Blocks.forgeTag("storage_blocks/charcoal");
        public static final TagKey<Block> STORAGE_BLOCKS_APATITE = Blocks.forgeTag("storage_blocks/apatite");
        public static final TagKey<Block> STORAGE_BLOCKS_TIN = Blocks.forgeTag("storage_blocks/tin");
        public static final TagKey<Block> STORAGE_BLOCKS_BRONZE = Blocks.forgeTag("storage_blocks/bronze");
        public static final TagKey<Block> ORES_TIN = Blocks.forgeTag("ores/tin");
        public static final TagKey<Block> ORES_APATITE = Blocks.forgeTag("ores/apatite");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_TIN = Blocks.forgeTag("storage_blocks/raw_tin");
        public static final TagKey<Block> PALM_LOGS = Blocks.tag("palm_logs");
        public static final TagKey<Block> PAPAYA_LOGS = Blocks.tag("papaya_logs");
        public static final TagKey<Block> VANILLA_FLOWERS = Blocks.tag("flowers/vanilla");
        public static final TagKey<Block> NETHER_FLOWERS = Blocks.tag("flowers/nether");
        public static final TagKey<Block> CACTI_FLOWERS = Blocks.tag("flowers/cacti");
        public static final TagKey<Block> MUSHROOMS_FLOWERS = Blocks.tag("flowers/mushrooms");
        public static final TagKey<Block> END_FLOWERS = Blocks.tag("flowers/end");
        public static final TagKey<Block> JUNGLE_FLOWERS = Blocks.tag("flowers/jungle");
        public static final TagKey<Block> SNOW_FLOWERS = Blocks.tag("flowers/snow");
        public static final TagKey<Block> WHEAT_FLOWERS = Blocks.tag("flowers/wheat");
        public static final TagKey<Block> GOURD_FLOWERS = Blocks.tag("flowers/gourd");
        public static final TagKey<Block> PLANTABLE_FLOWERS = Blocks.tag("flowers/plantable");
        public static final TagKey<Block> MODEST_BEE_GROUND = Blocks.tag("hive_grounds/modest");
        public static final TagKey<Block> WINTRY_BEE_GROUND = Blocks.tag("hive_grounds/wintry");

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)ForestryConstants.forestry(name));
        }

        private static TagKey<Block> forgeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }
}

