/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.api.ForestryConstants;
import forestry.api.core.IError;
import net.minecraft.resources.ResourceLocation;

public enum ForestryError implements IError
{
    TOO_HOT("too_hot"),
    TOO_COLD("too_cold"),
    TOO_HUMID("too_humid"),
    TOO_ARID("too_arid"),
    IS_RAINING("is_raining"),
    NOT_GLOOMY("not_gloomy"),
    NOT_BRIGHT("not_lucid"),
    NOT_DAY("not_day"),
    NOT_NIGHT("not_night"),
    NO_FLOWER("no_flower"),
    NO_QUEEN("no_queen"),
    NO_DRONE("no_drone"),
    NO_SKY("no_sky"),
    NO_RESOURCE("no_resource"),
    NO_RESOURCE_INVENTORY("no_resource_inventory", "no_resource"),
    NO_RESOURCE_LIQUID("no_resource_liquid", "no_liquid"),
    NO_RECIPE("no_recipe"),
    NO_SPACE_INVENTORY("no_space"),
    NO_SPACE_TANK("no_space_tank"),
    NO_POWER("no_power"),
    NO_REDSTONE("no_redstone", "disabled"),
    DISABLED_BY_REDSTONE("disabled_redstone", "disabled"),
    NOT_DARK("not_dark", "not_gloomy"),
    NOT_RAINING("not_raining"),
    NO_RAIN_BIOME("no_rain_biome", "not_raining"),
    NO_SKY_RAIN_TANK("no_sky_rain_tank", "no_sky"),
    NO_HONEY("no_honey"),
    NO_SPECIMEN("no_specimen"),
    FORCED_COOLDOWN("forced_cooldown"),
    NO_FUEL("no_fuel"),
    NO_HEAT("no_heat"),
    NO_ENERGY_NET("no_energy_net"),
    NO_STAMPS("no_stamps"),
    NO_PAPER("no_paper"),
    NO_SUPPLIES("no_supplies", "no_resource"),
    NO_TRADE("no_trade", "no_resource"),
    NOT_ALPHANUMERIC("not_alpha_numeric"),
    NOT_UNIQUE("not_unique"),
    NOT_POST_PAID("not_postpaid", "no_stamps"),
    NO_RECIPIENT("no_recipient"),
    NO_CIRCUIT_BOARD("no_circuit_board"),
    NO_CIRCUIT_LAYOUT("no_circuit_layout"),
    CIRCUIT_MISMATCH("circuit_mismatch"),
    NO_FERTILIZER("no_fertilizer"),
    NO_FARMLAND("no_farmland"),
    NO_LIQUID_FARM("no_liquid"),
    WRONG_RESOURCE("wrong_resource", "no_recipe");

    private final ResourceLocation id;
    private final ResourceLocation sprite;
    private final String descriptionKey;
    private final String helpKey;

    private ForestryError(String id) {
        this(id, id);
    }

    private ForestryError(String id, String iconName) {
        this.id = ForestryConstants.forestry(id);
        this.sprite = ForestryConstants.forestry("errors/" + iconName);
        String idDotted = this.id.m_135827_() + "." + this.id.m_135815_();
        this.descriptionKey = "errors." + idDotted + ".desc";
        this.helpKey = "errors." + idDotted + ".help";
    }

    @Override
    public String getDescriptionTranslationKey() {
        return this.descriptionKey;
    }

    @Override
    public String getHelpTranslationKey() {
        return this.helpKey;
    }

    @Override
    public ResourceLocation getSprite() {
        return this.sprite;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

