/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics.capability;

import forestry.api.ForestryCapabilities;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public interface IIndividualHandlerItem {
    public ItemStack getContainer();

    public ISpeciesType<?, ?> getSpeciesType();

    public ILifeStage getStage();

    public IIndividual getIndividual();

    public boolean isGeneticForm();

    public static void ifPresent(ItemStack stack, BiConsumer<IIndividual, ILifeStage> action) {
        stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).ifPresent(handler -> action.accept(handler.getIndividual(), handler.getStage()));
    }

    public static void ifPresent(ItemStack stack, Consumer<IIndividual> action) {
        stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).ifPresent(handler -> action.accept(handler.getIndividual()));
    }

    public static boolean isIndividual(ItemStack stack) {
        return stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM).isPresent();
    }

    public static boolean filter(ItemStack stack, Predicate<IIndividual> predicate) {
        IIndividualHandlerItem handler = (IIndividualHandlerItem)stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).orElse(null);
        return handler != null && predicate.test(handler.getIndividual());
    }

    public static boolean filter(ItemStack stack, BiPredicate<IIndividual, ILifeStage> predicate) {
        IIndividualHandlerItem handler = (IIndividualHandlerItem)stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).orElse(null);
        return handler != null && predicate.test(handler.getIndividual(), handler.getStage());
    }

    @Nullable
    public static IIndividualHandlerItem get(ItemStack stack) {
        return (IIndividualHandlerItem)stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).orElse(null);
    }

    @Nullable
    public static IIndividual getIndividual(ItemStack stack) {
        stack.reviveCaps();
        IIndividualHandlerItem handler = (IIndividualHandlerItem)stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM, null).orElse(null);
        return handler != null ? handler.getIndividual() : null;
    }

    public static <S extends ISpecies<?>> S getSpecies(ItemStack stack, ISpeciesType<S, ?> type) {
        IIndividual individual = IIndividualHandlerItem.getIndividual(stack);
        return (S)(individual != null ? individual.getSpecies() : type.getDefaultSpecies());
    }
}

