/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.blocks.BlockApiculture;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.tiles.TileBeeHouse;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ApiaristAI
extends MoveToBlockGoal {
    private final Villager villager;
    private boolean hasDrone;
    private boolean hasPrincess;
    private final SimpleContainer villagerInventory;
    private static final int SLOT_PRODUCT_1 = 2;
    private static final int SLOT_PRODUCT_COUNT = 7;
    private static final int SLOT_QUEEN = 0;
    private static final int SLOT_DRONE = 1;

    public ApiaristAI(Villager villager, double speed) {
        super((PathfinderMob)villager, speed, 16);
        this.villager = villager;
        this.villagerInventory = villager.m_35311_();
    }

    public boolean m_8036_() {
        if (this.f_25600_ <= 0) {
            this.hasDrone = this.hasBeeType(BeeLifeStage.DRONE);
            this.hasPrincess = this.hasBeeType(BeeLifeStage.PRINCESS);
        }
        return super.m_8036_();
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos housePos = this.f_25602_.m_122012_().m_7494_();
        this.villager.m_21563_().m_24950_((double)housePos.m_123341_() + 0.5, (double)housePos.m_123342_(), (double)housePos.m_123343_() + 0.5, 10.0f, (float)this.villager.m_8132_());
        if (this.m_25625_()) {
            Level world = this.villager.f_19853_;
            TileBeeHouse beeHouse = (TileBeeHouse)TileUtil.getTile((BlockGetter)world, housePos);
            if (beeHouse == null) {
                return;
            }
            InventoryBeeHousing inventory = (InventoryBeeHousing)beeHouse.getBeeInventory();
            for (ItemStack stack : InventoryUtil.getStacks((Container)inventory, 2, 7)) {
                Item item;
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemBeeGE)) continue;
                ItemBeeGE geneticItem = (ItemBeeGE)item;
                BeeLifeStage type = geneticItem.getStage();
                if (inventory.m_8020_(0).m_41619_() && type == BeeLifeStage.PRINCESS) {
                    inventory.setQueen(stack.m_41777_());
                    stack.m_41764_(0);
                    continue;
                }
                if (type != BeeLifeStage.DRONE) continue;
                stack.m_41774_(InventoryUtil.addStack((Container)inventory, stack, 1, 1, true));
            }
            if (inventory.m_8020_(1).m_41619_() || inventory.m_8020_(0).m_41619_()) {
                boolean princessAdded = false;
                boolean droneAdded = false;
                for (ItemStack stack : InventoryUtil.getStacks((Container)this.villagerInventory)) {
                    if (princessAdded && droneAdded) break;
                    if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemBeeGE)) continue;
                    BeeLifeStage type = ((ItemBeeGE)stack.m_41720_()).getStage();
                    if (type == BeeLifeStage.DRONE && inventory.m_8020_(1).m_41619_()) {
                        InventoryUtil.addStack((Container)inventory, stack, 1, 1, true);
                        droneAdded = true;
                        continue;
                    }
                    if (type != BeeLifeStage.PRINCESS || !inventory.m_8020_(0).m_41619_()) continue;
                    InventoryUtil.addStack((Container)inventory, stack, 0, 1, true);
                    princessAdded = true;
                }
            }
            for (ItemStack stack : InventoryUtil.getStacks((Container)inventory, 2, 7)) {
                if (!(stack.m_41720_() instanceof ItemBeeGE)) continue;
                InventoryUtil.addStack((Container)this.villagerInventory, stack, true);
            }
        }
        this.f_25600_ = 20;
    }

    public boolean hasBeeType(BeeLifeStage type) {
        if (this.villagerInventory.m_7983_()) {
            return false;
        }
        for (ItemStack stack : InventoryUtil.getStacks((Container)this.villagerInventory)) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemBeeGE) || ((ItemBeeGE)stack.m_41720_()).getStage() != type) continue;
            return true;
        }
        return false;
    }

    protected boolean m_6465_(LevelReader world, BlockPos pos) {
        BlockEntity blockEntity;
        Block block = world.m_8055_(pos = pos.m_122012_().m_7494_()).m_60734_();
        if (block instanceof BlockApiculture && (blockEntity = TileUtil.getTile((BlockGetter)world, pos)) instanceof TileBeeHouse) {
            TileBeeHouse beeHouse = (TileBeeHouse)blockEntity;
            InventoryBeeHousing inventory = (InventoryBeeHousing)beeHouse.getBeeInventory();
            if (inventory.m_7983_()) {
                return false;
            }
            if (!inventory.m_8020_(0).m_41619_()) {
                BeeLifeStage type = ((ItemBeeGE)inventory.m_8020_(0).m_41720_()).getStage();
                if (type == BeeLifeStage.QUEEN) {
                    return false;
                }
                if (type == BeeLifeStage.PRINCESS && !inventory.m_8020_(1).m_41619_() && !this.hasDrone) {
                    return false;
                }
            }
            boolean foundPrincess = this.hasPrincess;
            boolean foundDrone = this.hasDrone;
            if (foundDrone && foundPrincess) {
                return true;
            }
            for (ItemStack stack : InventoryUtil.getStacks((Container)inventory, 2, 7)) {
                if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemBeeGE)) continue;
                BeeLifeStage type = ((ItemBeeGE)stack.m_41720_()).getStage();
                if (type == BeeLifeStage.PRINCESS) {
                    foundPrincess = true;
                }
                if (type == BeeLifeStage.DRONE) {
                    foundDrone = true;
                }
                if (!foundDrone || !foundPrincess) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

