/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.IForestryApi;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.genetics.pollen.IPollen;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.network.packets.PacketBeeLogicActive;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeekeepingLogic
implements IBeekeepingLogic {
    private static final int totalBreedingTime = 100;
    private final IBeeHousing housing;
    private final IBeeModifier beeModifier;
    private final IBeeListener beeListener;
    private int beeProgress;
    private int beeProgressMax;
    private int queenWorkCycleThrottle;
    private IEffectData[] effectData = new IEffectData[2];
    private final Stack<ItemStack> spawn = new Stack();
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache();
    private final QueenCanWorkCache queenCanWorkCache = new QueenCanWorkCache();
    private final PollenHandler pollenHandler = new PollenHandler();
    private boolean active;
    @Nullable
    private IBee queen;
    private ItemStack queenStack = ItemStack.f_41583_;

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
        this.beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        this.beeListener = IForestryApi.INSTANCE.getHiveManager().createBeeHousingListener(housing);
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128405_("BreedingTime", this.beeProgress);
        compoundNBT.m_128405_("Throttle", this.queenWorkCycleThrottle);
        if (!this.queenStack.m_41619_()) {
            CompoundTag queenNbt = new CompoundTag();
            this.queenStack.m_41739_(queenNbt);
            compoundNBT.m_128365_("queen", (Tag)queenNbt);
        }
        compoundNBT.m_128379_("Active", this.active);
        this.hasFlowersCache.write(compoundNBT);
        Stack<ItemStack> spawnCopy = new Stack<ItemStack>();
        spawnCopy.addAll(this.spawn);
        ListTag nbttaglist = new ListTag();
        while (!spawnCopy.isEmpty()) {
            CompoundTag compoundNBT1 = new CompoundTag();
            ((ItemStack)spawnCopy.pop()).m_41739_(compoundNBT1);
            nbttaglist.add((Object)compoundNBT1);
        }
        compoundNBT.m_128365_("Offspring", (Tag)nbttaglist);
        return compoundNBT;
    }

    @Override
    public void read(CompoundTag compoundNBT) {
        this.beeProgress = compoundNBT.m_128451_("BreedingTime");
        this.queenWorkCycleThrottle = compoundNBT.m_128451_("Throttle");
        if (compoundNBT.m_128441_("queen")) {
            CompoundTag queenNBT = compoundNBT.m_128469_("queen");
            this.queenStack = ItemStack.m_41712_((CompoundTag)queenNBT);
            this.queen = (IBee)IIndividualHandlerItem.getIndividual(this.queenStack);
        }
        this.setActive(compoundNBT.m_128471_("Active"));
        this.hasFlowersCache.read(compoundNBT);
        ListTag list = compoundNBT.m_128437_("Offspring", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.spawn.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.writeBoolean(this.active);
        if (this.active) {
            data.m_130055_(this.queenStack);
            this.hasFlowersCache.writeData(data);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.queenStack = data.m_130267_();
            this.queen = (IBee)IIndividualHandlerItem.getIndividual(this.queenStack);
            this.hasFlowersCache.readData(data);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        boolean canWork;
        ILifeStage beeType;
        IErrorLogic errorLogic = this.housing.getErrorLogic();
        errorLogic.clearErrors();
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        boolean hasSpace = BeekeepingLogic.addPendingProducts(beeInventory, this.spawn);
        errorLogic.setCondition(!hasSpace, ForestryError.NO_SPACE_INVENTORY);
        ItemStack newQueenStack = beeInventory.getQueen();
        IIndividualHandlerItem handler = IIndividualHandlerItem.get(newQueenStack);
        ILifeStage iLifeStage = beeType = handler == null ? null : handler.getStage();
        if (beeType == BeeLifeStage.PRINCESS) {
            boolean hasDrone = ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).isDrone(beeInventory.getDrone());
            errorLogic.setCondition(!hasDrone, ForestryError.NO_DRONE);
            this.setActive(false);
            return !errorLogic.hasErrors();
        }
        if (beeType == BeeLifeStage.QUEEN) {
            IBee queen = (IBee)handler.getIndividual();
            if (!queen.isAlive()) {
                Collection<ItemStack> spawned = BeekeepingLogic.killQueen(queen, this.housing, this.beeListener);
                this.spawn.addAll(spawned);
                newQueenStack = ItemStack.f_41583_;
            }
        } else {
            newQueenStack = ItemStack.f_41583_;
        }
        if (this.queenStack != newQueenStack) {
            if (!newQueenStack.m_41619_()) {
                this.queen = (IBee)IIndividualHandlerItem.getIndividual(newQueenStack);
                if (this.queen != null) {
                    this.hasFlowersCache.onNewQueen(this.queen, this.housing);
                }
            } else {
                this.queen = null;
            }
            this.queenStack = newQueenStack;
            this.queenCanWorkCache.clear();
        }
        if (errorLogic.setCondition(this.queen == null, ForestryError.NO_QUEEN)) {
            this.setActive(false);
            this.beeProgress = 0;
            return false;
        }
        Set<IError> queenErrors = this.queenCanWorkCache.queenCanWork(this.queen, this.housing);
        for (IError errorState : queenErrors) {
            errorLogic.setCondition(true, errorState);
        }
        this.hasFlowersCache.update(this.queen, this.housing);
        boolean hasFlowers = this.hasFlowersCache.hasFlowers();
        boolean flowerCacheNeedsSync = this.hasFlowersCache.needsSync();
        errorLogic.setCondition(!hasFlowers, ForestryError.NO_FLOWER);
        boolean bl = canWork = !errorLogic.hasErrors();
        if (this.active != canWork) {
            this.setActive(canWork);
        } else if (flowerCacheNeedsSync) {
            this.syncToClient();
        }
        return canWork;
    }

    @Override
    public void doWork() {
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack queenStack = beeInventory.getQueen();
        IIndividualHandlerItem.ifPresent(queenStack, (individual, stage) -> {
            if (stage == BeeLifeStage.PRINCESS) {
                this.tickBreed();
            } else if (stage == BeeLifeStage.QUEEN) {
                this.queenWorkTick((IBee)individual, queenStack);
            }
        });
    }

    @Override
    public void clearCachedValues() {
        if (!this.housing.getWorldObj().f_46443_) {
            this.queenCanWorkCache.clear();
            this.canWork();
            if (this.queen != null) {
                this.hasFlowersCache.forceLookForFlowers(this.queen, this.housing);
            }
        }
    }

    private void queenWorkTick(@Nullable IBee queen, ItemStack queenStack) {
        if (queen == null) {
            this.beeProgress = 0;
            this.beeProgressMax = 0;
            return;
        }
        this.effectData = queen.doEffect(this.effectData, this.housing);
        ++this.queenWorkCycleThrottle;
        if (this.queenWorkCycleThrottle >= ModuleApiculture.ticksPerBeeWorkCycle) {
            BlockPos blockPos;
            this.queenWorkCycleThrottle = 0;
            BeekeepingLogic.doProduction(queen, this.housing, this.beeListener);
            Level world = this.housing.getWorldObj();
            List<BlockState> flowers = this.hasFlowersCache.getFlowers(world);
            if (flowers.size() < ModuleApiculture.maxFlowersSpawnedPerHive && (blockPos = queen.plantFlowerRandom(this.housing, flowers)) != null) {
                this.hasFlowersCache.addFlowerPos(blockPos);
            }
            this.pollenHandler.doPollination(queen, this.housing, this.beeListener);
            IGenome mate = queen.getMate();
            float lifespanModifier = this.beeModifier.modifyAging(queen.getGenome(), mate, 1.0f);
            queen.age(world, lifespanModifier);
            queen.saveToStack(queenStack);
            this.housing.getBeeInventory().setQueen(queenStack);
        }
        this.beeProgress = queen.getHealth();
        this.beeProgressMax = queen.getMaxHealth();
    }

    private static void doProduction(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        List<ItemStack> products = queen.produceStacks(beeHousing);
        beeListener.wearOutEquipment(1);
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        for (ItemStack stack : products) {
            beeInventory.addProduct(stack, false);
        }
    }

    private static boolean addPendingProducts(IBeeHousingInventory beeInventory, Stack<ItemStack> spawn) {
        boolean housingHasSpace = true;
        while (!spawn.isEmpty()) {
            ItemStack next = spawn.peek();
            if (beeInventory.addProduct(next, true)) {
                spawn.pop();
                continue;
            }
            housingHasSpace = false;
            break;
        }
        return housingHasSpace;
    }

    private void tickBreed() {
        this.beeProgressMax = 100;
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack droneStack = beeInventory.getDrone();
        ItemStack princessStack = beeInventory.getQueen();
        IIndividualHandlerItem droneType = IIndividualHandlerItem.get(droneStack);
        IIndividualHandlerItem princessType = IIndividualHandlerItem.get(princessStack);
        if (droneType == null || princessType == null || droneType.getStage() != BeeLifeStage.DRONE || princessType.getStage() != BeeLifeStage.PRINCESS) {
            this.beeProgress = 0;
            return;
        }
        if (this.beeProgress < 100) {
            ++this.beeProgress;
        }
        if (this.beeProgress < 100) {
            return;
        }
        IBee princess = (IBee)IIndividualHandlerItem.getIndividual(princessStack);
        IBee drone = (IBee)IIndividualHandlerItem.getIndividual(droneStack);
        princess.setMate(drone.getGenome());
        this.queenStack = princess.createStack(BeeLifeStage.QUEEN);
        beeInventory.setQueen(this.queenStack);
        ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getBreedingTracker((LevelAccessor)this.housing.getWorldObj(), this.housing.getOwner()).registerQueen(princess);
        droneStack.m_41774_(1);
        if (droneStack.m_41619_()) {
            beeInventory.setDrone(ItemStack.f_41583_);
        }
        this.queen = princess;
        this.beeProgress = princess.getHealth();
        this.beeProgressMax = princess.getMaxHealth();
    }

    private static Collection<ItemStack> killQueen(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        if (queen.getMate() == null) {
            queen.setMate(queen.getGenome());
        }
        Collection<ItemStack> spawn = BeekeepingLogic.spawnOffspring(queen, beeHousing);
        beeListener.onQueenDeath();
        beeInventory.getQueen().m_41764_(0);
        beeInventory.setQueen(ItemStack.f_41583_);
        return spawn;
    }

    private static Collection<ItemStack> spawnOffspring(IBee queen, IBeeHousing beeHousing) {
        int count;
        Level level = beeHousing.getWorldObj();
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getBreedingTracker((LevelAccessor)level, beeHousing.getOwner());
        boolean secondPrincess = (double)level.f_46441_.m_188503_(10000) < ModuleApiculture.getSecondPrincessChance() * 100.0;
        int n = count = secondPrincess ? 2 : 1;
        while (count > 0) {
            --count;
            IBee heiress = queen.spawnPrincess(beeHousing);
            if (heiress == null) continue;
            ItemStack princess = ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).createStack(heiress, (ILifeStage)BeeLifeStage.PRINCESS);
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        List<IBee> drones = queen.spawnDrones(beeHousing);
        for (IBee drone : drones) {
            ItemStack droneStack = new ItemStack((ItemLike)BeeLifeStage.DRONE.getItemForm());
            drone.saveToStack(droneStack);
            breedingTracker.registerDrone(drone);
            offspring.push(droneStack);
        }
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        ArrayList<ItemStack> spawn = new ArrayList<ItemStack>();
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (beeInventory.addProduct(spawned, true)) continue;
            spawn.add(spawned);
        }
        return spawn;
    }

    @Override
    public void syncToClient() {
        Level level = this.housing.getWorldObj();
        if (level != null && !level.f_46443_) {
            NetworkUtil.sendNetworkPacket(new PacketBeeLogicActive(this.housing), this.housing.getCoordinates(), level);
        }
    }

    @Override
    public void syncToClient(ServerPlayer player) {
        Level level = this.housing.getWorldObj();
        if (level != null && !level.f_46443_) {
            NetworkUtil.sendToPlayer(new PacketBeeLogicActive(this.housing), player);
        }
    }

    @Override
    public int getBeeProgressPercent() {
        if (this.beeProgressMax == 0) {
            return 0;
        }
        return Math.round((float)this.beeProgress * 100.0f / (float)this.beeProgressMax);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canDoBeeFX() {
        return !Minecraft.m_91087_().m_91104_() && this.active;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doBeeFX() {
        if (this.queen != null) {
            this.queen.doFX(this.effectData, this.housing);
        }
    }

    @Override
    public List<BlockPos> getFlowerPositions() {
        return this.hasFlowersCache.getFlowerCoords();
    }

    private static class QueenCanWorkCache {
        private static final int ticksPerCheckQueenCanWork = 10;
        private Set<IError> queenCanWorkCached = Collections.emptySet();
        private int queenCanWorkCooldown = 0;

        private QueenCanWorkCache() {
        }

        public Set<IError> queenCanWork(IBee queen, IBeeHousing beeHousing) {
            if (this.queenCanWorkCooldown <= 0) {
                this.queenCanWorkCached = queen.getCanWork(beeHousing);
                this.queenCanWorkCooldown = 10;
            } else {
                --this.queenCanWorkCooldown;
            }
            return this.queenCanWorkCached;
        }

        public void clear() {
            this.queenCanWorkCached.clear();
            this.queenCanWorkCooldown = 0;
        }
    }

    private static class PollenHandler {
        private static final int MAX_POLLINATION_ATTEMPTS = 20;
        @Nullable
        private IPollen<?> pollen;
        private int attemptedPollinations = 0;

        private PollenHandler() {
        }

        public void doPollination(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
            if (this.pollen == null) {
                this.attemptedPollinations = 0;
                this.pollen = queen.retrievePollen(beeHousing);
                if (this.pollen != null && beeListener.onPollenRetrieved(this.pollen)) {
                    this.pollen = null;
                }
            }
            if (this.pollen != null) {
                ++this.attemptedPollinations;
                if (queen.pollinateRandom(beeHousing, this.pollen) || this.attemptedPollinations >= 20) {
                    this.pollen = null;
                }
            }
        }
    }
}

