/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.api.ForestryTags;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveDrop;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.blocks.BlockHiveType;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.tiles.TileHive;
import forestry.core.tiles.TileUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BlockBeeHive
extends Block
implements EntityBlock {
    private final ResourceLocation speciesId;

    public BlockBeeHive(BlockHiveType type) {
        this(type.getSpeciesId());
    }

    public BlockBeeHive(ResourceLocation speciesId) {
        super(BlockBehaviour.Properties.m_60939_((Material)MaterialBeehive.BEEHIVE_WORLD).m_60918_(SoundType.f_56736_).m_60953_(state -> 7).m_60978_(2.5f));
        this.speciesId = speciesId;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileHive(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actualType) {
        return actualType != ApicultureTiles.HIVE.tileType() ? null : (level1, pos, state1, t) -> ((TileHive)t).tick(level1);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        TileUtil.actOnTile((LevelReader)world, pos, IHiveTile.class, tile -> tile.onAttack(world, pos, player));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        boolean canHarvest = this.canHarvestBlock(state, (BlockGetter)world, pos, player);
        TileUtil.actOnTile((LevelReader)world, pos, IHiveTile.class, tile -> tile.onBroken(world, pos, player, canHarvest));
    }

    @Nullable
    private ObjectArrayList<IHiveDrop> getDropsForHive() {
        List<IHiveDrop> drops = IForestryApi.INSTANCE.getHiveManager().getDrops(this.speciesId);
        if (drops.isEmpty()) {
            return null;
        }
        return new ObjectArrayList(drops);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockPos pos = new BlockPos((Vec3)builder.m_78970_(LootContextParams.f_81460_));
        ItemStack tool = (ItemStack)builder.m_78970_(LootContextParams.f_81463_);
        if (tool.m_204117_(ForestryTags.Items.SCOOPS)) {
            int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
            return this.getDrops(builder.m_78962_(), pos, fortune);
        }
        return List.of();
    }

    private List<ItemStack> getDrops(ServerLevel level, BlockPos pos, int fortune) {
        IBee bee;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        RandomSource random = level.m_213780_();
        ObjectArrayList<IHiveDrop> hiveDrops = this.getDropsForHive();
        if (hiveDrops == null) {
            return drops;
        }
        Util.m_214673_(hiveDrops, (RandomSource)level.f_46441_);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.m_188500_() < drop.getChance((BlockGetter)level, pos, fortune))) continue;
                bee = drop.createIndividual((BlockGetter)level, pos);
                if ((double)random.m_188501_() < drop.getIgnobleChance((BlockGetter)level, pos, fortune)) {
                    bee.setPristine(false);
                }
                ItemStack princess = bee.createStack(BeeLifeStage.PRINCESS);
                drops.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.m_188500_() < drop.getChance((BlockGetter)level, pos, fortune))) continue;
            bee = drop.createIndividual((BlockGetter)level, pos);
            ItemStack drone = bee.createStack(BeeLifeStage.DRONE);
            drops.add(drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.m_188500_() < drop.getChance((BlockGetter)level, pos, fortune))) continue;
            drops.addAll(drop.getExtraItems((BlockGetter)level, pos, fortune));
            break;
        }
        return drops;
    }

    public ResourceLocation getSpeciesId() {
        return this.speciesId;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }
}

