/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.compat.MutationRecipe;
import forestry.core.utils.JeiUtil;
import forestry.core.utils.ModUtil;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

class MutationsRecipeCategory
implements IRecipeCategory<MutationRecipe> {
    private static final int SPECIES_SLOTS_Y = 16;
    private static final int SPECIES_SLOT_0_X = 19;
    private static final int SPECIES_SLOT_1_X = 72;
    private static final int SPECIES_SLOT_2_X = 126;
    private final RecipeType<MutationRecipe> type;
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;
    final ISpeciesType<?, ?> speciesType;

    public MutationsRecipeCategory(ISpeciesType<?, ?> type, IDrawable background, IDrawable icon) {
        this.background = background;
        this.icon = icon;
        this.speciesType = type;
        this.type = new RecipeType(ModUtil.withSuffix(type.id(), "_mutations"), MutationRecipe.class);
        this.title = Component.m_237115_((String)("for.jei.mutations." + type.id().m_135827_() + "." + type.id().m_135815_()));
    }

    public RecipeType<MutationRecipe> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MutationRecipe recipe, IFocusGroup focuses) {
        IIngredientAcceptor inputs = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT);
        IIngredientAcceptor outputs = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        IMutation<?> mutation = recipe.mutation;
        ItemStack result = recipe.result;
        IIndividualHandlerItem resultHandler = IIndividualHandlerItem.get(result);
        IGenome resultGenome = resultHandler == null ? mutation.getResult().getDefaultGenome() : resultHandler.getIndividual().getGenome();
        for (ILifeStage stage : mutation.getType().getLifeStages()) {
            inputs.addItemStack(mutation.getFirstParent().createStack(stage));
            inputs.addItemStack(mutation.getSecondParent().createStack(stage));
            outputs.addItemStack(mutation.getResult().createIndividual(resultGenome).createStack(stage));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 16).addItemStack(recipe.firstParent);
        builder.addSlot(RecipeIngredientRole.INPUT, 72, 16).addItemStack(recipe.secondParent);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 126, 16).addItemStack(result);
    }

    static ItemStack createAnalyzedStack(ILifeStage stage, ISpecies<?> species, @Nullable IGenome genome) {
        if (genome == null) {
            genome = species.getDefaultGenome();
        }
        Object individual = species.createIndividual(genome);
        individual.analyze();
        return individual.createStack(stage);
    }

    public void draw(MutationRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        JeiUtil.drawCenteredMulti(stack, (Component)recipe.mutation.getFirstParent().getDisplayName(), 28.0f, 38.0f, -1);
        JeiUtil.drawCenteredMulti(stack, (Component)recipe.mutation.getSecondParent().getDisplayName(), 81.0f, 38.0f, -1);
        JeiUtil.drawCenteredMulti(stack, (Component)recipe.mutation.getResult().getDisplayName(), 135.0f, 38.0f, -1);
        List<Component> conditions = recipe.mutation.getSpecialConditions();
        String percentageString = JeiUtil.formatPercentage(recipe.mutation.getChance()) + "%";
        if (conditions.isEmpty()) {
            JeiUtil.drawCenteredMulti(stack, (Component)Component.m_237113_((String)percentageString), 105.0f, 12.0f, 0xFFFFFF);
        } else {
            JeiUtil.drawCenteredMulti(stack, (Component)Component.m_237113_((String)("[" + percentageString + "]")), 105.0f, 12.0f, 0xFFFFFF);
        }
    }

    public List<Component> getTooltipStrings(MutationRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List<Component> mutation = recipe.mutation.getSpecialConditions();
        if (!mutation.isEmpty() && mouseX >= 90.0 && mouseX <= 120.0 && mouseY >= 11.0 && mouseY <= 19.0) {
            return mutation;
        }
        return List.of();
    }
}

