/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import forestry.api.core.IProduct;
import forestry.api.core.IProductProducer;
import forestry.api.core.ISpecialtyProducer;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

class ProductRecipe {
    final ISpecies<?> species;
    final List<ItemStack> inputs;
    @Nullable
    final Object2FloatOpenHashMap<ItemStack> products;
    @Nullable
    final Object2FloatOpenHashMap<ItemStack> specialties;
    final ItemStack displayInput;

    ProductRecipe(ISpecies<?> species) {
        Object2FloatOpenHashMap<ItemStack> object2FloatOpenHashMap;
        Object producer;
        this.species = species;
        ItemStack displayInput = null;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ILifeStage displayStage = species.getType().getTypeForMutation(2);
        for (ILifeStage iLifeStage : species.getType().getLifeStages()) {
            ItemStack stack = species.createStack(iLifeStage);
            inputs.add(stack);
            if (iLifeStage != displayStage) continue;
            displayInput = stack;
        }
        this.inputs = inputs;
        this.displayInput = Objects.requireNonNull(displayInput);
        if (species instanceof IProductProducer) {
            producer = (IProductProducer)((Object)species);
            v0 = this.createProductsList(producer.getProducts());
        } else {
            v0 = this.products = null;
        }
        if (species instanceof ISpecialtyProducer) {
            producer = (ISpecialtyProducer)((Object)species);
            object2FloatOpenHashMap = this.createProductsList(producer.getSpecialties());
        } else {
            object2FloatOpenHashMap = null;
        }
        this.specialties = object2FloatOpenHashMap;
    }

    private Object2FloatOpenHashMap<ItemStack> createProductsList(List<IProduct> productGetter) {
        Object2FloatOpenHashMap list = new Object2FloatOpenHashMap(productGetter.size());
        for (IProduct product : productGetter) {
            ItemStack stack = product.createStack();
            list.put((Object)stack, product.chance());
        }
        return list;
    }
}

