/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IFlowerType;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeEffect;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.climate.IClimateManager;
import forestry.api.core.ForestryError;
import forestry.api.core.HumidityType;
import forestry.api.core.IError;
import forestry.api.core.IProduct;
import forestry.api.core.Product;
import forestry.api.core.TemperatureType;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.api.genetics.pollen.IPollen;
import forestry.api.genetics.pollen.IPollenManager;
import forestry.api.genetics.pollen.IPollenType;
import forestry.core.config.ForestryConfig;
import forestry.core.genetics.IndividualLiving;
import forestry.core.genetics.mutations.Mutation;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.VecUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class Bee
extends IndividualLiving<IBeeSpecies, IBee, IBeeSpeciesType>
implements IBee {
    public static final Codec<Bee> CODEC = RecordCodecBuilder.create(instance -> {
        Codec<IGenome> genomeCodec = ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getKaryotype().getGenomeCodec();
        return IndividualLiving.livingFields(instance, genomeCodec).and(instance.group((App)Codec.BOOL.fieldOf("pristine").forGetter(IBee::isPristine), (App)Codec.INT.optionalFieldOf("generation", (Object)0).forGetter(IBee::getGeneration))).apply((Applicative)instance, Bee::new);
    });
    private boolean pristine = true;
    private int generation;

    public Bee(IGenome genome) {
        super(genome);
    }

    private Bee(IGenome genome, Optional<IGenome> mate, boolean analyzed, int health, int maxHealth, boolean pristine, int generation) {
        super(genome, mate, analyzed, health, maxHealth);
        this.pristine = pristine;
        this.generation = generation;
    }

    public static Vec3i getModifiedArea(IGenome genome, IBeeHousing housing) {
        Vec3i area = Bee.getAdjustedTerritory(genome, IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing));
        int x = area.m_123341_();
        int y = area.m_123342_();
        int z = area.m_123343_();
        if (x < 1) {
            x = 1;
        }
        if (y < 1) {
            y = 1;
        }
        if (z < 1) {
            z = 1;
        }
        return new Vec3i(x, y, z);
    }

    @Override
    protected IIntegerChromosome getLifespanChromosome() {
        return BeeChromosomes.LIFESPAN;
    }

    @Override
    public void setPristine(boolean pristine) {
        this.pristine = pristine;
    }

    @Override
    public boolean isPristine() {
        return this.pristine;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IBeeEffect effect = this.genome.getActiveValue(BeeChromosomes.EFFECT);
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IBeeEffect secondary = this.genome.getInactiveValue(BeeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IBeeEffect effect = this.genome.getActiveValue(BeeChromosomes.EFFECT);
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IBeeEffect secondary = this.genome.getInactiveValue(BeeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public Set<IError> getCanWork(IBeeHousing housing) {
        ToleranceType beeToleranceHumidity;
        HumidityType beeBaseHumidity;
        HumidityType actualHumidity;
        ToleranceType beeToleranceTemperature;
        TemperatureType beeBaseTemperature;
        Level world = housing.getWorldObj();
        HashSet<IError> errorStates = new HashSet<IError>();
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        if (housing.isRaining() && !this.canFlyInRain(beeModifier)) {
            errorStates.add(ForestryError.IS_RAINING);
        }
        if (world.m_46461_()) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(ForestryError.NOT_NIGHT);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(ForestryError.NOT_DAY);
        }
        if (housing.getBlockLightValue() > 11) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(ForestryError.NOT_GLOOMY);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(ForestryError.NOT_BRIGHT);
        }
        if (!(world.m_6042_().f_63856_() || world.m_46472_() == Level.f_46430_ || housing.canBlockSeeTheSky() || this.canWorkUnderground(beeModifier))) {
            errorStates.add(ForestryError.NO_SKY);
        }
        IBeeSpecies species = (IBeeSpecies)this.species;
        TemperatureType actualTemperature = housing.temperature();
        if (!ClimateHelper.isWithinLimits(actualTemperature, beeBaseTemperature = species.getTemperature(), beeToleranceTemperature = this.genome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE))) {
            if (beeBaseTemperature.ordinal() > actualTemperature.ordinal()) {
                errorStates.add(ForestryError.TOO_COLD);
            } else {
                errorStates.add(ForestryError.TOO_HOT);
            }
        }
        if (!ClimateHelper.isWithinLimits(actualHumidity = housing.humidity(), beeBaseHumidity = species.getHumidity(), beeToleranceHumidity = this.genome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE))) {
            if (beeBaseHumidity.ordinal() > actualHumidity.ordinal()) {
                errorStates.add(ForestryError.TOO_ARID);
            } else {
                errorStates.add(ForestryError.TOO_HUMID);
            }
        }
        return errorStates;
    }

    private boolean canWorkAtNight(IBeeModifier beeModifier) {
        return this.genome.getActiveValue(BeeChromosomes.SPECIES).isNocturnal() || this.genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS) || beeModifier.isSelfLighted();
    }

    private boolean canWorkDuringDay() {
        return !this.genome.getActiveValue(BeeChromosomes.SPECIES).isNocturnal() || this.genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS);
    }

    private boolean canWorkUnderground(IBeeModifier beeModifier) {
        return this.genome.getActiveValue(BeeChromosomes.CAVE_DWELLING) || beeModifier.isSunlightSimulated();
    }

    private boolean canFlyInRain(IBeeModifier beeModifier) {
        return this.genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN) || beeModifier.isSealed();
    }

    private boolean isSuitableBiome(Holder<Biome> biome) {
        IClimateManager manager = IForestryApi.INSTANCE.getClimateManager();
        TemperatureType temperature = manager.getTemperature(biome);
        HumidityType humidity = manager.getHumidity(biome);
        return this.isSuitableClimate(temperature, humidity);
    }

    private boolean isSuitableClimate(TemperatureType temperature, HumidityType humidity) {
        return ClimateHelper.isWithinLimits(temperature, humidity, this.genome.getActiveValue(BeeChromosomes.SPECIES).getTemperature(), this.genome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE), this.genome.getActiveValue(BeeChromosomes.SPECIES).getHumidity(), this.genome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE));
    }

    @Override
    public List<Holder.Reference<Biome>> getSuitableBiomes(Registry<Biome> registry) {
        return registry.m_203611_().filter(this::isSuitableBiome).toList();
    }

    @Override
    public List<ItemStack> getProduceList() {
        IBeeSpecies secondary;
        IBeeSpecies primary = this.genome.getActiveValue(BeeChromosomes.SPECIES);
        if (primary == (secondary = this.genome.getInactiveValue(BeeChromosomes.SPECIES))) {
            List<IProduct> products = primary.getProducts();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(products.size());
            for (IProduct product : products) {
                stacks.add(product.createStack());
            }
            return stacks;
        }
        ObjectOpenCustomHashSet products = new ObjectOpenCustomHashSet(primary.getProducts().size(), Product.ITEM_ONLY_STRATEGY);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(products.size() + secondary.getProducts().size());
        for (IProduct product : primary.getProducts()) {
            products.add((Object)product);
            stacks.add(product.createStack());
        }
        for (IProduct product : secondary.getProducts()) {
            if (products.contains((Object)product)) continue;
            stacks.add(product.createStack());
        }
        return stacks;
    }

    @Override
    public List<ItemStack> getSpecialtyList() {
        List<IProduct> products = this.genome.getActiveValue(BeeChromosomes.SPECIES).getSpecialties();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(products.size());
        for (IProduct product : products) {
            stacks.add(product.createStack());
        }
        return stacks;
    }

    @Override
    public List<ItemStack> produceStacks(IBeeHousing housing) {
        Level level = housing.getWorldObj();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        IBeeSpecies primary = (IBeeSpecies)this.species;
        IBeeSpecies secondary = (IBeeSpecies)this.inactiveSpecies;
        IBeeModifier beeHousingModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        float speed = beeHousingModifier.modifyProductionSpeed(this.genome, this.genome.getActiveValue(BeeChromosomes.SPEED));
        RandomSource rand = level.f_46441_;
        for (IProduct product : primary.getProducts()) {
            if (!(rand.m_188501_() < product.chance() * speed)) continue;
            stacks.add(product.createRandomStack(rand));
        }
        for (IProduct product : secondary.getProducts()) {
            if (!(rand.m_188501_() < (float)Math.round(product.chance() / 2.0f) * speed)) continue;
            stacks.add(product.createRandomStack(rand));
        }
        if (primary.isJubilant(this.genome, housing) && secondary.isJubilant(this.genome, housing)) {
            for (IProduct product : primary.getSpecialties()) {
                if (!(rand.m_188501_() < product.chance() * speed)) continue;
                stacks.add(product.createRandomStack(rand));
            }
        }
        BlockPos housingCoordinates = housing.getCoordinates();
        return this.genome.getActiveValue(BeeChromosomes.FLOWER_TYPE).affectProducts(level, housingCoordinates, this, stacks);
    }

    @Override
    @Nullable
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (!this.pristine) {
            IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
            RandomSource rand = housing.getWorldObj().f_46441_;
            if (this.generation > 96 + rand.m_188503_(6) + rand.m_188503_(6) && rand.m_188501_() < 0.02f * beeModifier.modifyGeneticDecay(this.genome, 1.0f)) {
                return null;
            }
        }
        return this.createOffspring(housing, this.mate, this.getGeneration() + 1);
    }

    @Override
    public List<IBee> spawnDrones(IBeeHousing housing) {
        if (this.mate == null) {
            return Collections.emptyList();
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        int toCreate = this.genome.getActiveValue(BeeChromosomes.FERTILITY);
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, this.mate, 0);
            offspring.setPristine(true);
            bees.add(offspring);
        }
        return bees;
    }

    private IBee createOffspring(IBeeHousing housing, IGenome mate, int generation) {
        SpeciesUtil.ISpeciesMutator mutator = (p1, p2) -> Bee.mutateSpecies(housing, p1, p2);
        boolean haploid = generation == 0 && (Boolean)ForestryConfig.SERVER.useHaploidDrones.get() != false;
        return SpeciesUtil.createOffspring(housing.getWorldObj().f_46441_, this.genome, mate, mutator, genome -> new Bee((IGenome)genome, Optional.empty(), false, this.maxHealth, this.maxHealth, this.pristine, generation), haploid);
    }

    @Nullable
    private static ImmutableList<AllelePair<?>> mutateSpecies(IBeeHousing housing, IGenome parent1, IGenome parent2) {
        return SpeciesUtil.mutateSpecies(housing.getWorldObj(), housing.getCoordinates(), housing.getOwner(), parent1, parent2, BeeChromosomes.SPECIES, (mutation, level, pos, firstGenome, secondGenome, climate) -> Bee.getChance(mutation, housing, firstGenome, secondGenome));
    }

    private static float getChance(IMutation<IBeeSpecies> mutation, IBeeHousing housing, IGenome genome0, IGenome genome1) {
        BlockPos housingPos;
        Level level = housing.getWorldObj();
        float currentChance = Mutation.getChance(mutation, level, housingPos = housing.getCoordinates(), genome0, genome1, housing);
        if (currentChance <= 0.0f) {
            return 0.0f;
        }
        IBeeModifier beeHousingModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        currentChance = beeHousingModifier.modifyMutationChance(genome0, genome1, mutation, currentChance);
        return currentChance;
    }

    @Override
    @Nullable
    public IPollen<?> retrievePollen(IBeeHousing housing) {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        int chance = Bee.getAdjustedPollination(this.genome, beeModifier);
        Level level = housing.getWorldObj();
        RandomSource random = level.f_46441_;
        if (random.m_188503_(100) >= chance) {
            return null;
        }
        Vec3i area = Bee.getAdjustedTerritory(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.m_123341_() / 2, -area.m_123342_() / 4, -area.m_123343_() / 2);
        BlockPos housingPos = housing.getCoordinates();
        IPollenManager pollens = IForestryApi.INSTANCE.getPollenManager();
        for (int i = 0; i < 20; ++i) {
            IPollen<?> pollen;
            BlockPos randomPos = VecUtil.sum(new Vec3i[]{housingPos, VecUtil.getRandomPositionInArea(random, area), offset});
            if (!level.m_46805_(randomPos) || (pollen = pollens.getPollen((LevelAccessor)level, randomPos, this)) == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IPollen<?> pollen) {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        int chance = Bee.getAdjustedPollination(this.genome, beeModifier);
        Level level = housing.getWorldObj();
        RandomSource random = level.f_46441_;
        if (random.m_188503_(100) >= chance) {
            return false;
        }
        Vec3i area = Bee.getAdjustedTerritory(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.m_123341_() / 2, -area.m_123342_() / 4, -area.m_123343_() / 2);
        BlockPos housingPos = housing.getCoordinates();
        IPollenType<?> type = pollen.getType();
        for (int i = 0; i < 30; ++i) {
            BlockPos randomPos = VecUtil.sum(new Vec3i[]{housingPos, VecUtil.getRandomPositionInArea(random, area), offset});
            if (!type.tryPollinate((LevelAccessor)level, randomPos, pollen.castPollen(), this)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockPos plantFlowerRandom(IBeeHousing housing, List<BlockState> potentialFlowers) {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        int chance = Bee.getAdjustedPollination(this.genome, beeModifier);
        Level level = housing.getWorldObj();
        RandomSource random = level.f_46441_;
        if (random.m_188503_(100) >= chance) {
            return null;
        }
        IFlowerType flowerType = this.genome.getActiveValue(BeeChromosomes.FLOWER_TYPE);
        Vec3i area = Bee.getAdjustedTerritory(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.m_123341_() / 2, -area.m_123342_() / 4, -area.m_123343_() / 2);
        BlockPos housingPos = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            BlockPos randomPos = VecUtil.getRandomPositionInArea(random, area);
            BlockPos posBlock = VecUtil.sum(new Vec3i[]{housingPos, randomPos, offset});
            if (!flowerType.plantRandomFlower(level, posBlock, potentialFlowers)) continue;
            return posBlock;
        }
        return null;
    }

    @Override
    public Iterator<BlockPos.MutableBlockPos> getAreaIterator(IBeeHousing housing) {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        Vec3i area = Bee.getAdjustedTerritory(this.genome, beeModifier);
        BlockPos housingPos = housing.getCoordinates();
        BlockPos minPos = housingPos.m_7918_(-area.m_123341_() / 2, -area.m_123342_() / 2, -area.m_123343_() / 2);
        BlockPos maxPos = minPos.m_121955_(area);
        Level level = housing.getWorldObj();
        return VecUtil.getAllInBoxFromCenterMutable(level, minPos, housingPos, maxPos);
    }

    public static Vec3i getAdjustedTerritory(IGenome genome, IBeeModifier beeModifier) {
        return beeModifier.modifyTerritory(genome, genome.getActiveValue(BeeChromosomes.TERRITORY));
    }

    private static int getAdjustedPollination(IGenome genome, IBeeModifier beeModifier) {
        return Math.round(beeModifier.modifyPollination(genome, genome.getActiveValue(BeeChromosomes.POLLINATION)));
    }

    @Override
    protected void copyPropertiesTo(IBee other) {
        super.copyPropertiesTo(other);
        Bee bee = (Bee)other;
        bee.pristine = this.pristine;
        bee.generation = this.generation;
    }
}

