/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.IIntegerAllele;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.config.ForestryConfig;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public enum BeeAlyzerPlugin implements IAlyzerPlugin
{
    INSTANCE;

    private final Map<ISpecies<?>, ItemStack> iconStacks = GeneticsUtil.getIconStacks(BeeLifeStage.DRONE, (ISpeciesType)SpeciesUtil.BEE_TYPE.get());

    @Override
    public void drawAnalyticsPage1(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, (individual, stage) -> {
                if (individual instanceof IBee) {
                    IBee bee = (IBee)individual;
                    if (((Boolean)ForestryConfig.SERVER.useHaploidDrones.get()).booleanValue() && stage == BeeLifeStage.DRONE) {
                        TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                        textLayout.startPage(transform, 12, 90, 155);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                        textLayout.newLine();
                        textLayout.newLine();
                        guiAlyzer.drawHaploidSpeciesRow(transform, (Component)Component.m_237115_((String)"for.gui.species"), bee, BeeChromosomes.SPECIES);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.lifespan"), bee, BeeChromosomes.LIFESPAN);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.speed"), bee, BeeChromosomes.SPEED);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.pollination"), bee, BeeChromosomes.POLLINATION);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.flowers"), bee, BeeChromosomes.FLOWER_TYPE);
                        textLayout.newLine();
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.fertility"), 12);
                        IIntegerAllele primaryFertility = bee.getGenome().getActiveAllele(BeeChromosomes.FERTILITY);
                        guiAlyzer.drawFertilityInfo(transform, primaryFertility.value(), 90, GuiAlyzer.getColorCoding(primaryFertility.dominant()), 0);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.area"), bee, BeeChromosomes.TERRITORY);
                        textLayout.newLine();
                        guiAlyzer.drawHaploidChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.effect"), bee, BeeChromosomes.EFFECT);
                        textLayout.newLine();
                        textLayout.endPage(transform);
                    } else {
                        TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                        textLayout.startPage(transform, 12, 90, 155);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                        textLayout.newLine();
                        textLayout.newLine();
                        guiAlyzer.drawSpeciesRow(transform, (Component)Component.m_237115_((String)"for.gui.species"), bee, BeeChromosomes.SPECIES);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.lifespan"), bee, BeeChromosomes.LIFESPAN);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.speed"), bee, BeeChromosomes.SPEED);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.pollination"), bee, BeeChromosomes.POLLINATION);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.flowers"), bee, BeeChromosomes.FLOWER_TYPE);
                        textLayout.newLine();
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.fertility"), 12);
                        IIntegerAllele primaryFertility = bee.getGenome().getActiveAllele(BeeChromosomes.FERTILITY);
                        IIntegerAllele secondaryFertility = bee.getGenome().getInactiveAllele(BeeChromosomes.FERTILITY);
                        guiAlyzer.drawFertilityInfo(transform, primaryFertility.value(), 90, GuiAlyzer.getColorCoding(primaryFertility.dominant()), 0);
                        guiAlyzer.drawFertilityInfo(transform, secondaryFertility.value(), 155, GuiAlyzer.getColorCoding(secondaryFertility.dominant()), 0);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.area"), bee, BeeChromosomes.TERRITORY);
                        textLayout.newLine();
                        guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.effect"), bee, BeeChromosomes.EFFECT);
                        textLayout.newLine();
                        textLayout.endPage(transform);
                    }
                }
            });
        }
    }

    @Override
    public void drawAnalyticsPage2(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, (individual, type) -> {
                if (individual instanceof IBee) {
                    IBee bee = (IBee)individual;
                    if (((Boolean)ForestryConfig.SERVER.useHaploidDrones.get()).booleanValue() && type == BeeLifeStage.DRONE) {
                        MutableComponent nocturnal0;
                        MutableComponent diurnal0;
                        IGenome genome = bee.getGenome();
                        IBeeSpecies primaryAllele = genome.getActiveValue(BeeChromosomes.SPECIES);
                        TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                        textLayout.startPage(transform, 12, 90, 155);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                        textLayout.newLine();
                        textLayout.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.climate"), (Component)ClimateHelper.toDisplay(primaryAllele.getTemperature()), ColourProperties.INSTANCE.get("gui.screen"), GuiAlyzer.getColorCoding(((IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.SPECIES))).dominant()));
                        textLayout.newLine();
                        IValueAllele tempToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE));
                        textLayout.drawLine(transform, (Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance")), 12);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, tempToleranceActive, 90);
                        textLayout.newLine(16);
                        textLayout.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.humidity"), (Component)ClimateHelper.toDisplay(primaryAllele.getHumidity()), ColourProperties.INSTANCE.get("gui.screen"), GuiAlyzer.getColorCoding(((IValueAllele)((Object)individual.getGenome().getActiveAllele(BeeChromosomes.SPECIES))).dominant()));
                        textLayout.newLine();
                        IValueAllele humidToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE));
                        textLayout.drawLine(transform, (Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance")), 12);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.HUMIDITY_TOLERANCE, humidToleranceActive, 90);
                        textLayout.newLine(16);
                        MutableComponent yes = Component.m_237115_((String)"for.yes");
                        MutableComponent no = Component.m_237115_((String)"for.no");
                        if (genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS)) {
                            nocturnal0 = diurnal0 = yes;
                        } else {
                            nocturnal0 = primaryAllele.isNocturnal() ? yes : no;
                            diurnal0 = !primaryAllele.isNocturnal() ? yes : no;
                        }
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.diurnal"), 12);
                        textLayout.drawLine(transform, (Component)diurnal0, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.nocturnal"), 12);
                        textLayout.drawLine(transform, (Component)nocturnal0, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        MutableComponent primary = genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN) ? yes : no;
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.flyer"), 12);
                        textLayout.drawLine(transform, (Component)primary, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        primary = genome.getActiveValue(BeeChromosomes.CAVE_DWELLING) ? yes : no;
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.cave"), 12);
                        textLayout.drawLine(transform, (Component)primary, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.newLine();
                        textLayout.endPage(transform);
                    } else {
                        MutableComponent nocturnal1;
                        MutableComponent diurnal1;
                        MutableComponent nocturnal0;
                        MutableComponent diurnal0;
                        IGenome genome = bee.getGenome();
                        IBeeSpecies primaryAllele = genome.getActiveValue(BeeChromosomes.SPECIES);
                        IBeeSpecies secondaryAllele = genome.getInactiveValue(BeeChromosomes.SPECIES);
                        TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                        textLayout.startPage(transform, 12, 90, 155);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                        textLayout.newLine();
                        guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.climate"), (Component)ClimateHelper.toDisplay(primaryAllele.getTemperature()), (Component)ClimateHelper.toDisplay(secondaryAllele.getTemperature()), bee, BeeChromosomes.SPECIES);
                        textLayout.newLine();
                        IValueAllele tempToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE));
                        IValueAllele tempToleranceInactive = (IValueAllele)((Object)genome.getInactiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE));
                        textLayout.drawLine(transform, (Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance")), 12);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, tempToleranceActive, 90);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, tempToleranceInactive, 155);
                        textLayout.newLine(16);
                        guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.humidity"), (Component)ClimateHelper.toDisplay(primaryAllele.getHumidity()), (Component)ClimateHelper.toDisplay(secondaryAllele.getHumidity()), bee, BeeChromosomes.SPECIES);
                        textLayout.newLine();
                        IValueAllele humidToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE));
                        IValueAllele humidToleranceInactive = (IValueAllele)((Object)genome.getInactiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE));
                        textLayout.drawLine(transform, (Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance")), 12);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, humidToleranceActive, 90);
                        guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, humidToleranceInactive, 155);
                        textLayout.newLine(16);
                        MutableComponent yes = Component.m_237115_((String)"for.yes");
                        MutableComponent no = Component.m_237115_((String)"for.no");
                        if (genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS)) {
                            nocturnal0 = diurnal0 = yes;
                        } else {
                            nocturnal0 = primaryAllele.isNocturnal() ? yes : no;
                            MutableComponent mutableComponent = diurnal0 = !primaryAllele.isNocturnal() ? yes : no;
                        }
                        if (genome.getInactiveValue(BeeChromosomes.NEVER_SLEEPS)) {
                            nocturnal1 = diurnal1 = yes;
                        } else {
                            nocturnal1 = secondaryAllele.isNocturnal() ? yes : no;
                            diurnal1 = !secondaryAllele.isNocturnal() ? yes : no;
                        }
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.diurnal"), 12);
                        textLayout.drawLine(transform, (Component)diurnal0, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.drawLine(transform, (Component)diurnal1, 155, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.nocturnal"), 12);
                        textLayout.drawLine(transform, (Component)nocturnal0, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.drawLine(transform, (Component)nocturnal1, 155, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        MutableComponent primary = genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN) ? yes : no;
                        MutableComponent secondary = genome.getInactiveValue(BeeChromosomes.TOLERATES_RAIN) ? yes : no;
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.flyer"), 12);
                        textLayout.drawLine(transform, (Component)primary, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.drawLine(transform, (Component)secondary, 155, GuiAlyzer.getColorCoding(false));
                        textLayout.newLineCompressed();
                        primary = genome.getActiveValue(BeeChromosomes.CAVE_DWELLING) ? yes : no;
                        secondary = genome.getInactiveValue(BeeChromosomes.CAVE_DWELLING) ? yes : no;
                        textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.cave"), 12);
                        textLayout.drawLine(transform, (Component)primary, 90, GuiAlyzer.getColorCoding(false));
                        textLayout.drawLine(transform, (Component)secondary, 155, GuiAlyzer.getColorCoding(false));
                        textLayout.newLine();
                        if (type == BeeLifeStage.PRINCESS || type == BeeLifeStage.QUEEN) {
                            String displayTextKey = "for.bees.stock.pristine";
                            if (!bee.isPristine()) {
                                displayTextKey = "for.bees.stock.ignoble";
                            }
                            MutableComponent displayText = Component.m_237115_((String)displayTextKey);
                            textLayout.drawCenteredLine(transform, (Component)displayText, 8, 208, guiAlyzer.getFontColor().get("gui.beealyzer.binomial"));
                        }
                        if (bee.getGeneration() > 0) {
                            textLayout.newLineCompressed();
                            MutableComponent displayText = Component.m_237110_((String)"for.gui.beealyzer.generations", (Object[])new Object[]{bee.getGeneration()});
                            textLayout.drawCenteredLine(transform, (Component)displayText, 8, 208, guiAlyzer.getFontColor().get("gui.beealyzer.binomial"));
                        }
                        textLayout.endPage(transform);
                    }
                }
            });
        }
    }

    @Override
    public void drawAnalyticsPage3(PoseStack transform, Screen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(itemStack, individual -> {
                if (individual instanceof IBee) {
                    IBee bee = (IBee)individual;
                    TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                    WidgetManager widgetManager = guiAlyzer.getWidgetManager();
                    textLayout.startPage(transform, 12, 90, 155);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.beealyzer.produce").m_130946_(":"), 12);
                    textLayout.newLine();
                    int x = 12;
                    for (ItemStack stack : bee.getProduceList()) {
                        widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                        if ((x += 18) <= 148) continue;
                        x = 12;
                        textLayout.newLine();
                    }
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.beealyzer.specialty").m_130946_(":"), 12);
                    textLayout.newLine();
                    x = 12;
                    for (ItemStack stack : bee.getSpecialtyList()) {
                        widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                        if ((x += 18) <= 148) continue;
                        x = 12;
                        textLayout.newLine();
                    }
                    textLayout.endPage(transform);
                }
            });
        }
    }

    @Override
    public Map<ISpecies<?>, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return GuiForestry.HINTS.get((Object)"beealyzer");
    }
}

