/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.SpeciesUtil;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class BeeDatabaseTab
implements IDatabaseTab<IBee> {
    private final DatabaseMode mode;

    BeeDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(DatabaseElement container, IBee bee, ILifeStage stage, ItemStack stack) {
        MutableComponent nocturnal;
        MutableComponent diurnal;
        IBeeSpecies activeSpecies = bee.getGenome().getActiveValue(BeeChromosomes.SPECIES);
        IBeeSpecies inactiveSpecies = bee.getGenome().getInactiveValue(BeeChromosomes.SPECIES);
        container.label((Component)Component.m_237115_((String)("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species")), Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.databaseTitle);
        container.addLine((Component)Component.m_237115_((String)"for.gui.species").m_130940_(ChatFormatting.WHITE), BeeChromosomes.SPECIES);
        Function<Boolean, Component> toleranceText = a -> {
            IBeeSpecies species = a != false ? activeSpecies : inactiveSpecies;
            return ClimateHelper.toDisplay(species.getTemperature());
        };
        container.addLine((Component)Component.m_237115_((String)"for.gui.climate").m_130948_(GuiElementFactory.INSTANCE.guiStyle), toleranceText, BeeChromosomes.TEMPERATURE_TOLERANCE);
        container.addToleranceLine(BeeChromosomes.TEMPERATURE_TOLERANCE);
        container.addLine((Component)Component.m_237115_((String)"for.gui.humidity"), toleranceText, BeeChromosomes.HUMIDITY_TOLERANCE);
        container.addToleranceLine(BeeChromosomes.HUMIDITY_TOLERANCE);
        container.addLine((Component)Component.m_237115_((String)"for.gui.lifespan"), BeeChromosomes.LIFESPAN);
        container.addLine((Component)Component.m_237115_((String)"for.gui.speed"), BeeChromosomes.SPEED);
        container.addLine((Component)Component.m_237115_((String)"for.gui.pollination"), BeeChromosomes.POLLINATION);
        container.addLine((Component)Component.m_237115_((String)"for.gui.flowers"), BeeChromosomes.FLOWER_TYPE);
        container.addFertilityLine((Component)Component.m_237115_((String)"for.gui.fertility"), BeeChromosomes.FERTILITY, 0);
        container.addLine((Component)Component.m_237115_((String)"for.gui.area"), BeeChromosomes.TERRITORY);
        container.addLine((Component)Component.m_237115_((String)"for.gui.effect"), BeeChromosomes.EFFECT);
        MutableComponent yes = Component.m_237115_((String)"for.yes");
        MutableComponent no = Component.m_237115_((String)"for.no");
        if (this.mode == DatabaseMode.ACTIVE) {
            if (bee.getGenome().getActiveValue(BeeChromosomes.NEVER_SLEEPS)) {
                nocturnal = diurnal = yes;
            } else {
                nocturnal = activeSpecies.isNocturnal() ? yes : no;
                diurnal = !activeSpecies.isNocturnal() ? yes : no;
            }
        } else if (bee.getGenome().getInactiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
            nocturnal = diurnal = yes;
        } else {
            nocturnal = inactiveSpecies.isNocturnal() ? yes : no;
            diurnal = !inactiveSpecies.isNocturnal() ? yes : no;
        }
        container.addLine((Component)Component.m_237115_((String)"for.gui.diurnal"), (Component)diurnal, false);
        container.addLine((Component)Component.m_237115_((String)"for.gui.nocturnal"), (Component)nocturnal, false);
        Function<Boolean, Component> flyer = arg_0 -> BeeDatabaseTab.lambda$createElements$1(bee, (Component)yes, (Component)no, arg_0);
        container.addLine((Component)Component.m_237115_((String)"for.gui.flyer"), flyer, (IChromosome)BeeChromosomes.TOLERATES_RAIN);
        Function<Boolean, Component> cave = arg_0 -> BeeDatabaseTab.lambda$createElements$2(bee, (Component)yes, (Component)no, arg_0);
        container.addLine((Component)Component.m_237115_((String)"for.gui.cave"), cave, (IChromosome)BeeChromosomes.CAVE_DWELLING);
        if (stage == BeeLifeStage.PRINCESS || stage == BeeLifeStage.QUEEN) {
            MutableComponent displayTextKey = Component.m_237115_((String)"for.bees.stock.pristine");
            if (!bee.isPristine()) {
                displayTextKey = Component.m_237115_((String)"for.bees.stock.ignoble");
            }
            container.label((Component)displayTextKey, Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.binomial);
        }
    }

    @Override
    public ItemStack getIconStack() {
        return ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).createStack(ForestryBeeSpecies.MEADOWS, (ILifeStage)(this.mode == DatabaseMode.ACTIVE ? BeeLifeStage.PRINCESS : BeeLifeStage.DRONE));
    }

    private static /* synthetic */ Component lambda$createElements$2(IBee bee, Component yes, Component no, Boolean active) {
        boolean caveDwelling = active != false ? bee.getGenome().getActiveValue(BeeChromosomes.CAVE_DWELLING) : bee.getGenome().getInactiveValue(BeeChromosomes.CAVE_DWELLING);
        return caveDwelling ? yes : no;
    }

    private static /* synthetic */ Component lambda$createElements$1(IBee bee, Component yes, Component no, Boolean active) {
        boolean toleratesRain = active != false ? bee.getGenome().getActiveValue(BeeChromosomes.TOLERATES_RAIN) : bee.getGenome().getInactiveValue(BeeChromosomes.TOLERATES_RAIN);
        return toleratesRain ? yes : no;
    }
}

