/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SnowingBeeEffect
extends ThrottledBeeEffect {
    public SnowingBeeEffect() {
        super(false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        TemperatureType temp = housing.temperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vec3i area = Bee.getModifiedArea(genome, housing);
        BlockPos offset = VecUtil.scale(area, -0.5f);
        for (int i = 0; i < 1; ++i) {
            BlockPos randomPos = VecUtil.getRandomPositionInArea(level.f_46441_, area);
            BlockPos posBlock = randomPos.m_121955_((Vec3i)housing.getCoordinates()).m_121955_((Vec3i)offset);
            if (!level.m_46805_(posBlock)) continue;
            BlockState state = level.m_8055_(posBlock);
            Block block = state.m_60734_();
            if (!state.m_60795_() && block != Blocks.f_50125_ || !Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, posBlock)) continue;
            if (block == Blocks.f_50125_) {
                int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                if (layers < 7) {
                    BlockState moreSnow = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1));
                    level.m_46597_(posBlock, moreSnow);
                    continue;
                }
                level.m_46597_(posBlock, Blocks.f_50125_.m_49966_());
                continue;
            }
            if (!block.m_49966_().m_60767_().m_76336_()) continue;
            level.m_46597_(posBlock, Blocks.f_50125_.m_49966_());
        }
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorldObj().f_46441_.m_188503_(3) == 0) {
            Vec3i area = Bee.getModifiedArea(genome, housing);
            BlockPos offset = VecUtil.scale(area, -0.5f);
            BlockPos coordinates = housing.getCoordinates();
            Level world = housing.getWorldObj();
            BlockPos spawn = VecUtil.getRandomPositionInArea(world.f_46441_, area).m_121955_((Vec3i)coordinates).m_121955_((Vec3i)offset);
            ParticleRender.addEntitySnowFX(world, spawn.m_123341_(), spawn.m_123342_(), spawn.m_123343_());
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

