/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.features.ApicultureMenuTypes;
import forestry.apiculture.gui.ContainerBeeHelper;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.IContainerBeeHousing;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.gui.ContainerAnalyzerProvider;
import forestry.core.network.packets.PacketGuiStream;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.BlockGetter;

public class ContainerBeeHousing
extends ContainerAnalyzerProvider<TileBeeHousingBase>
implements IContainerBeeHousing {
    private final IGuiBeeHousingDelegate delegate;
    private final GuiBeeHousing.Icon icon;
    private int beeProgress = -1;

    public static ContainerBeeHousing fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buffer) {
        TileBeeHousingBase tile = TileUtil.getTile((BlockGetter)inv.f_35978_.f_19853_, buffer.m_130135_(), TileBeeHousingBase.class);
        boolean hasFrames = buffer.readBoolean();
        GuiBeeHousing.Icon icon = (GuiBeeHousing.Icon)NetworkUtil.readEnum((FriendlyByteBuf)buffer, (Enum[])GuiBeeHousing.Icon.VALUES);
        return new ContainerBeeHousing(windowId, inv, tile, hasFrames, icon);
    }

    public ContainerBeeHousing(int windowId, Inventory playerInv, TileBeeHousingBase tile, boolean hasFrames, GuiBeeHousing.Icon icon) {
        super(windowId, ApicultureMenuTypes.BEE_HOUSING.menuType(), playerInv, tile, 8, 108);
        ContainerBeeHelper.addSlots(this, tile, hasFrames);
        tile.getBeekeepingLogic().clearCachedValues();
        this.delegate = tile;
        this.icon = icon;
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        int beeProgress = ((TileBeeHousingBase)this.tile).getBeekeepingLogic().getBeeProgressPercent();
        if (this.beeProgress != beeProgress) {
            this.beeProgress = beeProgress;
            PacketGuiStream packet = new PacketGuiStream((TileBeeHousingBase)this.tile);
            this.sendPacketToListeners(packet);
        }
    }

    @Override
    public IGuiBeeHousingDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public GuiBeeHousing.Icon getIcon() {
        return this.icon;
    }
}

