/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.gui.GuiAnalyzerProvider;
import forestry.core.render.EnumTankLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiAlveary
extends GuiAnalyzerProvider<ContainerAlveary> {
    private final TileAlveary tile;

    public GuiAlveary(ContainerAlveary container, Inventory inventory, Component title) {
        super("textures/gui/alveary.png", container, inventory, () -> title, 25, 7, 2, 0);
        this.tile = (TileAlveary)container.getTile();
        this.f_97727_ = 190;
        this.analyzer.init();
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(transform, partialTicks, mouseX, mouseY);
        IAlvearyControllerInternal alvearyController = ((MultiblockLogicAlveary)this.tile.getMultiblockLogic()).getController();
        this.drawHealthMeter(transform, this.f_97735_ + 20, this.f_97736_ + 37, alvearyController.getHealthScaled(46), EnumTankLevel.rateTankLevel(alvearyController.getHealthScaled(100)));
    }

    private void drawHealthMeter(PoseStack transform, int x, int y, int height, EnumTankLevel rated) {
        int i = 176 + rated.getLevelScaled(16);
        int k = 0;
        this.m_93228_(transform, x, y + 46 - height, i, k + 46 - height, 4, height);
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addClimateLedger(this.tile);
        this.addHintLedger("apiary");
        this.addOwnerLedger(this.tile);
    }

    @Override
    protected void drawSelectedSlot(PoseStack transform, int selectedSlot) {
        Slot slot = ((ContainerAlveary)this.f_97732_).getForestrySlot(1 + selectedSlot);
        SELECTED_COMB_SLOT.draw(transform, this.f_97736_ + slot.f_40221_ - 3, this.f_97735_ + slot.f_40220_ - 3);
    }

    @Override
    public ItemStack getSpecimen(int index) {
        Slot slot = ((ContainerAlveary)this.f_97732_).getForestrySlot(this.getSelectedSlot(index));
        return slot.m_7993_();
    }

    @Override
    protected boolean hasErrors() {
        return this.tile.getErrorLogic().hasErrors();
    }
}

