/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.apiculture.gui.IContainerBeeHousing;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiAnalyzerProvider;
import forestry.core.gui.slots.SlotWatched;
import forestry.core.render.EnumTankLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiBeeHousing<C extends ContainerForestry>
extends GuiAnalyzerProvider<C> {
    private final IGuiBeeHousingDelegate delegate;

    public GuiBeeHousing(C container, Inventory inv, Component title) {
        super("textures/gui" + ((IContainerBeeHousing)container).getIcon().path, container, inv, ((IContainerBeeHousing)container).getDelegate(), 25, 7, 2, 0);
        this.delegate = ((IContainerBeeHousing)container).getDelegate();
        this.f_97727_ = 190;
        for (int i = 0; i < 2; ++i) {
            Slot queenSlot = ((ContainerForestry)((Object)container)).getForestrySlot(1 + i);
            if (!(queenSlot instanceof SlotWatched)) continue;
            SlotWatched watched = (SlotWatched)queenSlot;
            watched.setChangeWatcher(this);
        }
        this.analyzer.init();
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(transform, partialTicks, mouseX, mouseY);
        this.bindTexture(this.textureFile);
        this.drawHealthMeter(transform, this.f_97735_ + 20, this.f_97736_ + 37, this.delegate.getHealthScaled(46), EnumTankLevel.rateTankLevel(this.delegate.getHealthScaled(100)));
    }

    @Override
    protected void drawSelectedSlot(PoseStack transform, int selectedSlot) {
        Slot slot = ((ContainerForestry)this.f_97732_).getForestrySlot(1 + selectedSlot);
        SELECTED_COMB_SLOT.draw(transform, this.f_97736_ + slot.f_40221_ - 3, this.f_97735_ + slot.f_40220_ - 3);
    }

    private void drawHealthMeter(PoseStack transform, int x, int y, int height, EnumTankLevel rated) {
        int i = 176 + rated.getLevelScaled(16);
        int k = 0;
        this.m_93228_(transform, x, y + 46 - height, i, k + 46 - height, 4, height);
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.delegate);
        this.addClimateLedger(this.delegate);
        this.addHintLedger(this.delegate.getHintKey());
        this.addOwnerLedger(this.delegate);
    }

    @Override
    public ItemStack getSpecimen(int index) {
        Slot slot = ((ContainerForestry)this.f_97732_).getForestrySlot(this.getSelectedSlot(index));
        return slot.m_7993_();
    }

    @Override
    protected boolean hasErrors() {
        return this.delegate.getErrorLogic().hasErrors();
    }

    public static enum Icon {
        APIARY("/apiary.png"),
        BEE_HOUSE("/alveary.png");

        public static final Icon[] VALUES;
        private final String path;

        private Icon(String path) {
            this.path = path;
        }

        static {
            VALUES = Icon.values();
        }
    }
}

