/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HabitatSlot
extends Widget {
    private final TagKey<Biome> biomes;
    private final String name;
    private final ResourceLocation iconIndex;
    public boolean isActive = false;

    public HabitatSlot(WidgetManager widgetManager, int xPos, int yPos, String name, TagKey<Biome> biomes) {
        super(widgetManager, xPos, yPos);
        this.biomes = biomes;
        this.name = name;
        this.iconIndex = ForestryConstants.forestry("habitats/" + name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.add((Component)Component.m_237113_((String)this.name));
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon() {
        return IForestryClientApi.INSTANCE.getTextureManager().getSprite(this.iconIndex);
    }

    public void setActive(Set<TagKey<Biome>> biomes) {
        this.isActive = biomes.contains(this.biomes);
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        if (!this.isActive) {
            RenderSystem.m_157429_((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
        GuiComponent.m_93200_((PoseStack)transform, (int)(startX + this.xPos), (int)(startY + this.yPos), (int)this.manager.gui.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)this.getIcon());
    }
}

