/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.apiculture.hives.IHive;
import forestry.api.apiculture.hives.IHiveDefinition;
import forestry.api.apiculture.hives.IHiveDrop;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public final class Hive
implements IHive {
    private final IHiveDefinition hiveDescription;
    private final List<IHiveDrop> drops;

    public Hive(IHiveDefinition definition, List<IHiveDrop> drops) {
        this.hiveDescription = definition;
        this.drops = drops;
    }

    @Override
    public IHiveDefinition getDefinition() {
        return this.hiveDescription;
    }

    @Override
    public BlockState getHiveBlockState() {
        return this.hiveDescription.getBlockState();
    }

    @Override
    public List<IHiveDrop> getDrops() {
        return this.drops;
    }

    @Override
    public float genChance() {
        return this.hiveDescription.getGenChance();
    }

    @Override
    public void postGen(WorldGenLevel world, RandomSource rand, BlockPos pos) {
        this.hiveDescription.postGen(world, rand, pos);
    }

    @Override
    public boolean isGoodBiome(Holder<Biome> biome) {
        return this.hiveDescription.isGoodBiome(biome);
    }

    @Override
    public boolean isGoodHumidity(HumidityType humidity) {
        return this.hiveDescription.isGoodHumidity(humidity);
    }

    @Override
    public boolean isGoodTemperature(TemperatureType temperature) {
        return this.hiveDescription.isGoodTemperature(temperature);
    }

    @Override
    public boolean isValidLocation(WorldGenLevel world, BlockPos pos) {
        return this.hiveDescription.getHiveGen().isValidLocation(world, pos);
    }

    @Override
    public boolean canReplace(WorldGenLevel world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return this.hiveDescription.getHiveGen().canReplace(blockState, world, pos);
    }

    @Override
    @Nullable
    public BlockPos getPosForHive(WorldGenLevel level, int posX, int posZ) {
        return this.hiveDescription.getHiveGen().getPosForHive(level, posX, posZ);
    }

    @Override
    public String toString() {
        return this.hiveDescription + " hive";
    }
}

