/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.apiculture.hives.IHiveGen;
import forestry.core.utils.BlockUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;

public class HiveGenGround
implements IHiveGen {
    private final Set<Material> groundMaterials = new HashSet<Material>();

    public HiveGenGround(Block ... groundBlocks) {
        for (Block block : groundBlocks) {
            BlockState blockState = block.m_49966_();
            Material blockMaterial = blockState.m_60767_();
            this.groundMaterials.add(blockMaterial);
        }
    }

    @Override
    public boolean isValidLocation(WorldGenLevel world, BlockPos pos) {
        BlockState groundBlockState = world.m_8055_(pos.m_7495_());
        Material groundBlockMaterial = groundBlockState.m_60767_();
        return this.groundMaterials.contains(groundBlockMaterial);
    }

    @Override
    public BlockPos getPosForHive(WorldGenLevel level, int posX, int posZ) {
        int minBuildHeight;
        int groundY = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, posX, posZ);
        if (groundY == (minBuildHeight = level.m_141937_())) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(posX, groundY, posZ);
        BlockState blockState = level.m_8055_((BlockPos)pos);
        while (IHiveGen.isTreeBlock(blockState) || this.canReplace(blockState, level, (BlockPos)pos)) {
            pos.m_122173_(Direction.DOWN);
            if (pos.m_123342_() <= minBuildHeight) {
                return null;
            }
            blockState = level.m_8055_((BlockPos)pos);
        }
        return pos.m_7494_();
    }

    @Override
    public boolean canReplace(BlockState blockState, WorldGenLevel world, BlockPos pos) {
        return BlockUtil.canReplace(blockState, (LevelAccessor)world, pos);
    }
}

