/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.apiculture.hives.IHiveGen;
import forestry.core.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public enum HiveGenTree implements IHiveGen
{
    INSTANCE;


    @Override
    public boolean canReplace(BlockState blockState, WorldGenLevel world, BlockPos pos) {
        return BlockUtil.canReplace(blockState, (LevelAccessor)world, pos);
    }

    @Override
    public boolean isValidLocation(WorldGenLevel world, BlockPos pos) {
        BlockPos posAbove = pos.m_7494_();
        BlockState blockStateAbove = world.m_8055_(posAbove);
        if (!IHiveGen.isTreeBlock(blockStateAbove)) {
            return false;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockState blockStateBelow = world.m_8055_(posBelow);
        return this.canReplace(blockStateBelow, world, posBelow);
    }

    @Override
    public BlockPos getPosForHive(WorldGenLevel level, int posX, int posZ) {
        ChunkAccess chunk = level.m_6325_(posX >> 4, posZ >> 4);
        int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, posX & 0xFF, posZ & 0xFF) - 1;
        if (height <= chunk.m_141937_()) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(posX, height, posZ);
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (!IHiveGen.isTreeBlock(state)) {
            return null;
        }
        do {
            pos.m_122173_(Direction.DOWN);
        } while (IHiveGen.isTreeBlock(state = chunk.m_8055_((BlockPos)pos)));
        return pos.m_7949_();
    }
}

