/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import com.mojang.datafixers.util.Pair;
import forestry.api.apiculture.genetics.IBee;
import forestry.apiculture.network.packets.PacketHabitatBiomePointer;
import forestry.core.utils.NetworkUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class HabitatLocatorLogic {
    private Set<Holder<Biome>> targetBiomes = new HashSet<Holder<Biome>>();
    private boolean biomeFound = false;
    @Nullable
    private BlockPos searchCenter;

    public boolean isBiomeFound() {
        return this.biomeFound;
    }

    public Set<Holder<Biome>> getTargetBiomes() {
        return this.targetBiomes;
    }

    public void startBiomeSearch(IBee bee, Player player) {
        this.targetBiomes = new HashSet<Holder.Reference<Biome>>(bee.getSuitableBiomes((Registry<Biome>)player.m_9236_().m_5962_().m_175515_(Registry.f_122885_)));
        this.biomeFound = false;
        this.searchCenter = player.m_20183_();
        if (player.f_19853_.f_46443_) {
            // empty if block
        }
    }

    public void onUpdate(Level world, Entity player) {
        ServerPlayer serverPlayer;
        block6: {
            block5: {
                if (!(player instanceof ServerPlayer)) break block5;
                serverPlayer = (ServerPlayer)player;
                if (!this.targetBiomes.isEmpty() && this.searchCenter != null) break block6;
            }
            return;
        }
        if (this.biomeFound && world.m_46467_() % 50L != 0L) {
            return;
        }
        Pair pair = ((ServerLevel)player.m_9236_()).m_215069_(biome -> this.targetBiomes.contains(biome.get()), this.searchCenter, 4096, 32, 64);
        if (pair != null) {
            NetworkUtil.sendToPlayer(new PacketHabitatBiomePointer((BlockPos)pair.getFirst()), serverPlayer);
            this.biomeFound = true;
        }
    }
}

