/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemBeeGE
extends ItemGE
implements IColoredItem {
    public ItemBeeGE(BeeLifeStage type) {
        super(type != BeeLifeStage.DRONE ? new Item.Properties().m_41491_(ItemGroups.tabApiculture).m_41487_(1) : new Item.Properties().m_41491_(ItemGroups.tabApiculture), type);
    }

    @Override
    protected ISpeciesType<?, ?> getType() {
        return (ISpeciesType)SpeciesUtil.BEE_TYPE.get();
    }

    protected IBeeSpecies getSpecies(ItemStack stack) {
        return (IBeeSpecies)IIndividualHandlerItem.getSpecies(stack, (ISpeciesType)SpeciesUtil.BEE_TYPE.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        if (this.stage != BeeLifeStage.DRONE) {
            IIndividualHandlerItem.ifPresent(stack, individual -> {
                if (((IBee)individual).isPristine()) {
                    list.add((Component)Component.m_237115_((String)"for.bees.stock.pristine").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
                } else {
                    list.add((Component)Component.m_237115_((String)"for.bees.stock.ignoble").m_130940_(ChatFormatting.YELLOW));
                }
            });
        }
        super.m_7373_(stack, level, list, flag);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_220152_(tab)) {
            ItemGE.addCreativeItems(this.stage, subItems, true, (ISpeciesType)SpeciesUtil.BEE_TYPE.get());
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        if (!stack.m_41782_()) {
            if (tintIndex == 1) {
                return 16768022;
            }
            if (tintIndex == 2) {
                return 0;
            }
            return 0xFFFFFF;
        }
        IBeeSpecies species = this.getSpecies(stack);
        return switch (tintIndex) {
            case 2 -> species.getStripes();
            case 1 -> species.getBody();
            case 0 -> species.getOutline();
            default -> 0xFFFFFF;
        };
    }

    public final BeeLifeStage getStage() {
        return (BeeLifeStage)this.stage;
    }
}

