/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.IGenome;
import forestry.core.items.ItemForestry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemHiveFrame
extends ItemForestry
implements IHiveFrame {
    private final HiveFrameBeeModifier beeModifier;

    public ItemHiveFrame(int maxDamage, float geneticDecay) {
        super(new Item.Properties().m_41503_(maxDamage).m_41491_(ItemGroups.tabApiculture));
        this.beeModifier = new HiveFrameBeeModifier(geneticDecay);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 64;
    }

    @Override
    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        if (frame.m_220157_(wear, housing.getWorldObj().m_213780_(), null)) {
            return ItemStack.f_41583_;
        }
        return frame;
    }

    @Override
    public IBeeModifier getBeeModifier(ItemStack frame) {
        return this.beeModifier;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        this.beeModifier.addInformation(tooltip);
        if (!stack.m_41768_()) {
            tooltip.add((Component)Component.m_237110_((String)"item.forestry.durability", (Object[])new Object[]{stack.m_41776_()}));
        }
    }

    private static class HiveFrameBeeModifier
    implements IBeeModifier {
        private static final float production = 2.0f;
        private final float geneticDecay;

        public HiveFrameBeeModifier(float geneticDecay) {
            this.geneticDecay = geneticDecay;
        }

        @Override
        public float modifyProductionSpeed(IGenome genome, float currentSpeed) {
            return currentSpeed < 10.0f ? currentSpeed * 2.0f : 1.0f;
        }

        @Override
        public float modifyGeneticDecay(IGenome genome, float currentDecay) {
            return this.geneticDecay;
        }

        public void addInformation(List<Component> tooltip) {
            tooltip.add((Component)Component.m_237110_((String)"item.forestry.bee.modifier.production", (Object[])new Object[]{Float.valueOf(2.0f)}));
            tooltip.add((Component)Component.m_237110_((String)"item.forestry.bee.modifier.genetic.decay", (Object[])new Object[]{Float.valueOf(this.geneticDecay)}));
        }
    }
}

