/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.core.ItemGroups;
import forestry.core.items.ItemForestry;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class ItemSmoker
extends ItemForestry {
    public ItemSmoker() {
        super(new Item.Properties().m_41487_(1).m_41491_(ItemGroups.tabApiculture));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.f_46443_ && isSelected && worldIn.f_46441_.m_188503_(40) == 0) {
            ItemSmoker.addSmoke(stack, worldIn, entityIn, 1);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        Level world = player.f_19853_;
        ItemSmoker.addSmoke(stack, world, (Entity)player, count % 5 + 1);
    }

    private static HumanoidArm getHandSide(ItemStack stack, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entity;
            InteractionHand activeHand = LivingEntity2.m_7655_();
            HumanoidArm handSide = LivingEntity2.m_5737_();
            if (activeHand == InteractionHand.OFF_HAND) {
                handSide = handSide == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
            }
            return handSide;
        }
        return HumanoidArm.RIGHT;
    }

    private static void addSmoke(ItemStack stack, Level world, Entity entity, int distance) {
        if (distance <= 0) {
            return;
        }
        Vec3 look = entity.m_20154_();
        HumanoidArm handSide = ItemSmoker.getHandSide(stack, entity);
        Vec3 handOffset = handSide == HumanoidArm.RIGHT ? look.m_82537_(new Vec3(0.0, 1.0, 0.0)) : look.m_82537_(new Vec3(0.0, -1.0, 0.0));
        Vec3 lookDistance = new Vec3(look.f_82479_ * (double)distance, look.f_82480_ * (double)distance, look.f_82481_ * (double)distance);
        Vec3 scaledOffset = handOffset.m_82490_(1.0 / (double)distance);
        Vec3 smokePos = lookDistance.m_82549_(entity.m_20182_()).m_82549_(scaledOffset);
        if (world.f_46443_) {
            ParticleRender.addEntitySmokeFX(world, smokePos.f_82479_, smokePos.f_82480_ + 1.0, smokePos.f_82481_);
        }
        BlockPos blockPos = new BlockPos(smokePos.f_82479_, smokePos.f_82480_ + 1.0, smokePos.f_82481_);
        TileUtil.actOnTile((LevelReader)world, blockPos, IHiveTile.class, IHiveTile::calmBees);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        playerIn.m_6672_(handIn);
        ItemStack itemStack = playerIn.m_21120_(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileUtil.actOnTile((LevelReader)context.m_43725_(), context.m_8083_(), IHiveTile.class, IHiveTile::calmBees);
        return super.onItemUseFirst(stack, context);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }
}

