/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.client.IForestryClientApi;
import forestry.api.client.apiculture.IBeeClientManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.utils.SpeciesUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class ModelBee
implements IUnbakedGeometry<ModelBee> {
    private final ILifeStage stage;

    public ModelBee(ILifeStage stage) {
        this.stage = stage;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        IBeeClientManager manager = IForestryClientApi.INSTANCE.getBeeManager();
        Map<IBeeSpecies, ResourceLocation> models = manager.getBeeModels(this.stage);
        IdentityHashMap<IBeeSpecies, BakedModel> itemModels = new IdentityHashMap<IBeeSpecies, BakedModel>();
        for (IBeeSpecies species : SpeciesUtil.getAllBeeSpecies()) {
            ResourceLocation location = models.get(species);
            BakedModel model = bakery.bake(location, (ModelState)BlockModelRotation.X0_Y0, spriteGetter);
            if (model == null) continue;
            itemModels.put(species, model);
        }
        return new Baked(itemModels);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        IBeeClientManager manager = IForestryClientApi.INSTANCE.getBeeManager();
        Map<IBeeSpecies, ResourceLocation> models = manager.getBeeModels(this.stage);
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (IBeeSpecies species : SpeciesUtil.getAllBeeSpecies()) {
            locations.add(models.get(species));
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (ResourceLocation location : locations) {
            materials.addAll(modelGetter.apply(location).m_5500_(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    private static class Baked
    implements BakedModel {
        private final IdentityHashMap<IBeeSpecies, BakedModel> itemModels;

        public Baked(IdentityHashMap<IBeeSpecies, BakedModel> itemModels) {
            this.itemModels = itemModels;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
            return List.of();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return null;
        }

        public ItemOverrides m_7343_() {
            return new OverrideList();
        }

        public class OverrideList
        extends ItemOverrides {
            public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
                IIndividual individual = IIndividualHandlerItem.getIndividual(stack);
                if (individual == null) {
                    return model;
                }
                return Baked.this.itemModels.getOrDefault(individual.getSpecies(), model);
            }
        }
    }

    public static class Loader
    implements IGeometryLoader<ModelBee> {
        private final ModelBee[] models = new ModelBee[BeeLifeStage.values().length];

        public ModelBee read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            String stageName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"stage");
            BeeLifeStage stage = BeeLifeStage.valueOf(stageName.toUpperCase(Locale.ENGLISH));
            int ordinal = stage.ordinal();
            if (this.models[ordinal] == null) {
                this.models[ordinal] = new ModelBee(stage);
            }
            return this.models[ordinal];
        }
    }
}

