/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.proxy;

import forestry.api.ForestryConstants;
import forestry.api.client.IClientModuleHandler;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureMenuTypes;
import forestry.apiculture.gui.GuiAlveary;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearySieve;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.models.ModelBee;
import forestry.apiculture.particles.ApicultureParticles;
import forestry.apiculture.particles.BeeExploreParticle;
import forestry.apiculture.particles.BeeRoundTripParticle;
import forestry.apiculture.particles.BeeTargetEntityParticle;
import forestry.apiculture.particles.ParticleSnow;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ApicultureClientHandler
implements IClientModuleHandler {
    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(ApicultureClientHandler::setupClient);
        modBus.addListener(ApicultureClientHandler::registerParticleFactory);
        modBus.addListener(ApicultureClientHandler::hackFixForSnowingEffect);
        modBus.addListener(ApicultureClientHandler::handleSprites);
        modBus.addListener(ApicultureClientHandler::registerModelLoaders);
    }

    private static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ApicultureBlocks.BEE_COMB.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
            MenuScreens.m_96206_(ApicultureMenuTypes.ALVEARY.menuType(), GuiAlveary::new);
            MenuScreens.m_96206_(ApicultureMenuTypes.ALVEARY_HYGROREGULATOR.menuType(), GuiAlvearyHygroregulator::new);
            MenuScreens.m_96206_(ApicultureMenuTypes.ALVEARY_SIEVE.menuType(), GuiAlvearySieve::new);
            MenuScreens.m_96206_(ApicultureMenuTypes.ALVEARY_SWARMER.menuType(), GuiAlvearySwarmer::new);
            MenuScreens.m_96206_(ApicultureMenuTypes.BEE_HOUSING.menuType(), GuiBeeHousing::new);
        });
    }

    private static void registerParticleFactory(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)ApicultureParticles.BEE_EXPLORER_PARTICLE.get(), BeeExploreParticle.Factory::new);
        event.register((ParticleType)ApicultureParticles.BEE_ROUND_TRIP_PARTICLE.get(), BeeRoundTripParticle.Factory::new);
        event.register((ParticleType)ApicultureParticles.BEE_TARGET_ENTITY_PARTICLE.get(), BeeTargetEntityParticle.Factory::new);
    }

    private static void hackFixForSnowingEffect(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            for (int i = 0; i < ParticleSnow.sprites.length; ++i) {
                event.addSprite(ForestryConstants.forestry("particle/snow." + (i + 1)));
            }
        }
    }

    private static void handleSprites(TextureStitchEvent.Post event) {
        TextureAtlas map = event.getAtlas();
        if (map.m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            for (int i = 0; i < ParticleSnow.sprites.length; ++i) {
                ParticleSnow.sprites[i] = map.m_118316_(ForestryConstants.forestry("particle/snow." + (i + 1)));
            }
        }
    }

    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("bee_ge", (IGeometryLoader)new ModelBee.Loader());
    }
}

