/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class HygroregulatorRecipe
implements IHygroregulatorRecipe {
    private final ResourceLocation id;
    private final FluidStack liquid;
    private final byte humiditySteps;
    private final byte temperatureSteps;
    private final int retainTime;

    public HygroregulatorRecipe(ResourceLocation id, FluidStack liquid, int retainTime, byte humiditySteps, byte temperatureSteps) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)liquid);
        this.id = id;
        this.liquid = liquid;
        this.retainTime = retainTime;
        this.humiditySteps = humiditySteps;
        this.temperatureSteps = temperatureSteps;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.liquid;
    }

    @Override
    public int getRetainTime() {
        return this.retainTime;
    }

    @Override
    public byte getHumiditySteps() {
        return this.humiditySteps;
    }

    @Override
    public byte getTemperatureSteps() {
        return this.temperatureSteps;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.HYGROREGULATOR.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.HYGROREGULATOR.type();
    }

    public static class Serializer
    implements RecipeSerializer<HygroregulatorRecipe> {
        public HygroregulatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStack liquid = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"liquid"));
            int transferTime = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            byte humiditySteps = GsonHelper.m_144790_((JsonObject)json, (String)"humidity_steps");
            byte temperatureSteps = GsonHelper.m_144790_((JsonObject)json, (String)"temperature_steps");
            return new HygroregulatorRecipe(recipeId, liquid, transferTime, humiditySteps, temperatureSteps);
        }

        public HygroregulatorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidStack liquid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            int retainTime = buffer.m_130242_();
            byte humiditySteps = buffer.readByte();
            byte temperatureSteps = buffer.readByte();
            return new HygroregulatorRecipe(recipeId, liquid, retainTime, humiditySteps, temperatureSteps);
        }

        public void toNetwork(FriendlyByteBuf buffer, HygroregulatorRecipe recipe) {
            recipe.liquid.writeToPacket(buffer);
            buffer.m_130130_(recipe.retainTime);
            buffer.writeByte((int)recipe.humiditySteps);
            buffer.writeByte((int)recipe.temperatureSteps);
        }
    }
}

