/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.network.IStreamableGui;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileBase;
import forestry.core.utils.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileBeeHousingBase
extends TileBase
implements IBeeHousing,
IOwnedTile,
IClimateProvider,
IGuiBeeHousingDelegate,
IStreamableGui {
    private final String hintKey;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IBeekeepingLogic beeLogic;
    protected IClimateProvider climate = IForestryApi.INSTANCE.getClimateManager().createDummyClimateProvider();
    private int breedingProgressPercent = 0;

    protected TileBeeHousingBase(BlockEntityType<?> type, BlockPos pos, BlockState state, String hintKey) {
        super(type, pos, state);
        this.hintKey = hintKey;
        this.beeLogic = IForestryApi.INSTANCE.getHiveManager().createBeekeepingLogic(this);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)level, this.f_58858_);
    }

    @Override
    public String getHintKey() {
        return this.hintKey;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.beeLogic.write(compoundNBT);
        this.ownerHandler.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.beeLogic.read(compoundNBT);
        this.ownerHandler.read(compoundNBT);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.beeLogic.write(updateTag);
        this.ownerHandler.write(updateTag);
        return updateTag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.beeLogic.read(tag);
        this.ownerHandler.read(tag);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public TemperatureType temperature() {
        return this.climate.temperature();
    }

    @Override
    public HumidityType humidity() {
        return this.climate.humidity();
    }

    @Override
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                TileBeeHousingBase.doPollenFX(level, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doPollenFX(Level world, double xCoord, double yCoord, double zCoord) {
        double fxX = xCoord + 0.5;
        double fxY = yCoord + 0.25;
        double fxZ = zCoord + 0.5;
        float distanceFromCenter = 0.6f;
        float leftRightSpreadFromCenter = distanceFromCenter * (world.f_46441_.m_188501_() - 0.5f);
        float upSpread = world.f_46441_.m_188501_() * 6.0f / 16.0f;
        ParticleRender.addEntityHoneyDustFX(world, fxX - (double)distanceFromCenter, fxY += (double)upSpread, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)distanceFromCenter, fxY, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ - (double)distanceFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ + (double)distanceFromCenter);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
        if ((level.m_46467_() & 0x3FL) == 0L) {
            this.climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)level, pos);
        }
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        data.m_130130_(this.beeLogic.getBeeProgressPercent());
        NetworkUtil.writeClimateState(data, this.climate);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        this.breedingProgressPercent = data.m_130242_();
        this.climate = NetworkUtil.readClimateState(data);
    }

    @Override
    public Holder<Biome> getBiome() {
        return this.f_58857_.m_204166_(this.m_58899_());
    }

    @Override
    public int getBlockLightValue() {
        return this.f_58857_.m_46803_(this.m_58899_().m_7494_());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.f_58857_.m_45527_(this.m_58899_().m_7494_());
    }

    @Override
    public boolean isRaining() {
        return this.f_58857_.m_46758_(this.m_58899_().m_7494_());
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    }
}

