/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.client.IClientModuleHandler;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.IIndividual;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.ForestryModuleIds;
import forestry.api.modules.IPacketRegistry;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.client.ArboricultureClientHandler;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.arboriculture.villagers.ArboricultureVillagers;
import forestry.core.genetics.capability.IndividualHandlerItem;
import forestry.core.network.PacketIdClient;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.BlankForestryModule;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;

@ForestryModule
public class ModuleArboriculture
extends BlankForestryModule {
    @Override
    public ResourceLocation getId() {
        return ForestryModuleIds.ARBORICULTURE;
    }

    @Override
    public void registerEvents(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(ArboricultureVillagers::villagerTrades);
        modBus.addListener(ModuleArboriculture::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, ModuleArboriculture::attachCapabilities);
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (!event.getCapabilities().containsKey(IIndividual.CAPABILITY_ID)) {
            ItemStack stack = (ItemStack)event.getObject();
            ITreeSpeciesType type = (ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get();
            ITree individual = type.getVanillaIndividual(stack.m_41720_());
            if (individual != null) {
                event.addCapability(IIndividual.CAPABILITY_ID, (ICapabilityProvider)new IndividualHandlerItem(type, stack, individual, TreeLifeStage.SAPLING));
            }
        }
    }

    @Override
    public void setupApi() {
        TreeManager.woodAccess = WoodAccess.INSTANCE;
    }

    @Override
    public void addToRootCommand(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(CommandTree.register());
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IArmorNaturalist.class);
    }

    @Override
    public void registerPackets(IPacketRegistry registry) {
        registry.clientbound(PacketIdClient.RIPENING_UPDATE, PacketRipeningUpdate.class, PacketRipeningUpdate::decode, PacketRipeningUpdate::handle);
    }

    @Override
    public void registerClientHandler(Consumer<IClientModuleHandler> registrar) {
        registrar.accept(new ArboricultureClientHandler());
    }
}

