/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.core.IProduct;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.Fruit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.client.event.TextureStitchEvent;

public class RipeningFruit
extends Fruit {
    private final int colourCallow;
    private final int diffR;
    private final int diffG;
    private final int diffB;
    private final ResourceLocation sprite;

    public RipeningFruit(boolean dominant, int ripeningPeriod, ResourceLocation sprite, int ripe, int callow, List<IProduct> products) {
        super(dominant, ripeningPeriod, products);
        this.sprite = sprite;
        this.colourCallow = callow;
        this.diffR = (ripe >> 16 & 0xFF) - (callow >> 16 & 0xFF);
        this.diffG = (ripe >> 8 & 0xFF) - (callow >> 8 & 0xFF);
        this.diffB = (ripe & 0xFF) - (callow & 0xFF);
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public boolean isFruitLeaf() {
        return true;
    }

    @Override
    public int getColour(IGenome genome, BlockGetter world, BlockPos pos, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        return this.getColour(stage);
    }

    private int getColour(float stage) {
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public int getDecorativeColor() {
        return this.getColour(1.0f);
    }

    @Override
    public ResourceLocation getSprite(IGenome genome, BlockGetter world, BlockPos pos, int ripeningTime) {
        return this.sprite;
    }

    @Override
    public ResourceLocation getDecorativeSprite() {
        return this.sprite;
    }

    @Override
    public void registerSprites(TextureStitchEvent.Pre event) {
        event.addSprite(this.sprite);
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }
}

