/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.core.HumidityType;
import forestry.api.core.IProduct;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.plugin.ITreeSpeciesBuilder;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGrowthHelper;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.genetics.Species;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TreeSpecies
extends Species<ITreeSpeciesType, ITree>
implements ITreeSpecies {
    private final TemperatureType temperature;
    private final HumidityType humidity;
    private final ITreeGenerator generator;
    private final List<BlockState> vanillaLeafStates;
    private final List<Item> vanillaSaplingItems;
    private final ItemStack decorativeLeaves;
    private final float rarity;

    public TreeSpecies(ResourceLocation id, ITreeSpeciesType speciesType, IGenome defaultGenome, ITreeSpeciesBuilder builder) {
        super(id, speciesType, defaultGenome, builder);
        this.temperature = builder.getTemperature();
        this.humidity = builder.getHumidity();
        this.generator = builder.getGenerator();
        this.vanillaLeafStates = builder.getVanillaLeafStates();
        this.vanillaSaplingItems = builder.getVanillaSaplingItems();
        this.decorativeLeaves = builder.getDecorativeLeaves();
        this.rarity = builder.getRarity();
    }

    @Override
    public ITreeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public ItemStack getDecorativeLeaves() {
        return this.decorativeLeaves;
    }

    @Override
    public TemperatureType getTemperature() {
        return this.temperature;
    }

    @Override
    public HumidityType getHumidity() {
        return this.humidity;
    }

    @Override
    public List<BlockState> getVanillaLeafStates() {
        return this.vanillaLeafStates;
    }

    @Override
    public List<Item> getVanillaSaplingItems() {
        return this.vanillaSaplingItems;
    }

    @Override
    public int getGermlingColor(ILifeStage stage, int renderPass) {
        return stage == TreeLifeStage.POLLEN ? this.getEscritoireColor() : 0xFFFFFF;
    }

    @Override
    public ITree createIndividual(IGenome genome) {
        return new Tree(genome);
    }

    @Override
    public int getEscritoireColor() {
        return this.escritoireColor;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isFruitLeaf(LevelAccessor level, BlockPos pos) {
        TileLeaves leaves;
        BlockEntity blockEntity;
        return level.m_8055_(pos).m_60734_() instanceof BlockDefaultLeavesFruit || (blockEntity = level.m_7702_(pos)) instanceof TileLeaves && (leaves = (TileLeaves)blockEntity).hasFruit();
    }

    @Override
    public float getHeightModifier(IGenome genome) {
        return genome.getActiveValue(TreeChromosomes.HEIGHT);
    }

    @Override
    public void addTooltip(ITree individual, List<Component> tooltip) {
        if (!individual.isAnalyzed()) {
            TreeSpecies.addUnknownGenomeTooltip(tooltip);
            return;
        }
        IGenome genome = individual.getGenome();
        this.addHybridTooltip(tooltip, genome, TreeChromosomes.SPECIES, "for.trees.hybrid");
        MutableComponent saplingsAndMaturation = Component.m_237113_((String)"S: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.SAPLINGS)).m_130946_(", ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)"M: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.MATURATION)).m_130940_(ChatFormatting.RED));
        MutableComponent heightAndGirth = Component.m_237113_((String)"H: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.HEIGHT)).m_130946_(", ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"G: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.GIRTH)).m_130940_(ChatFormatting.AQUA));
        MutableComponent yieldAndSappiness = Component.m_237113_((String)"Y: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.YIELD)).m_130946_(", ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"S: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.SAPPINESS)).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)saplingsAndMaturation);
        tooltip.add((Component)heightAndGirth);
        tooltip.add((Component)yieldAndSappiness);
        if (genome.getActiveValue(TreeChromosomes.FIREPROOF)) {
            tooltip.add((Component)Component.m_237115_((String)"for.gui.fireresist").m_130940_(ChatFormatting.RED));
        }
        if (genome.getActiveAllele(TreeChromosomes.FRUIT) != ForestryAlleles.FRUIT_NONE) {
            tooltip.add((Component)Component.m_237113_((String)"F: ").m_7220_((Component)genome.getActiveName(TreeChromosomes.FRUIT)).m_130940_(ChatFormatting.GREEN));
        }
    }

    @Override
    @Nullable
    public BlockPos getGrowthPos(IGenome genome, LevelAccessor level, BlockPos pos, int expectedGirth, int expectedHeight) {
        return TreeGrowthHelper.getGrowthPos(level, genome, pos, expectedGirth, expectedHeight);
    }

    @Override
    public int getGirth(IGenome genome) {
        return genome.getActiveValue(TreeChromosomes.GIRTH);
    }

    @Override
    public boolean setLeaves(IGenome genome, LevelAccessor level, BlockPos pos, RandomSource random, boolean convertBlockEntity) {
        if (convertBlockEntity) {
            BlockState state = LeavesBlock.m_54435_((BlockState)ArboricultureBlocks.LEAVES.defaultState(), (LevelAccessor)level, (BlockPos)pos);
            boolean wasFruit = this.isFruitLeaf(level, pos);
            boolean placed = level.m_7731_(pos, state, 19);
            if (placed) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof TileLeaves) {
                    TileLeaves leaves = (TileLeaves)blockEntity;
                    Tree tree = new Tree(genome);
                    leaves.setTree(tree);
                    if (wasFruit) {
                        leaves.setFruit(tree, true);
                        leaves.addRipeness(1.0f);
                        leaves.m_6596_();
                    }
                } else {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 19);
                }
            }
            return false;
        }
        return this.getGenerator().setLeaves(genome, level, pos, random);
    }

    @Override
    public boolean setLogBlock(IGenome genome, LevelAccessor level, BlockPos pos, Direction facing) {
        return this.getGenerator().setLogBlock(genome, level, pos, facing);
    }

    @Override
    public boolean allowsFruitBlocks(IGenome genome) {
        return genome.getActiveValue(TreeChromosomes.FRUIT).requiresFruitBlocks();
    }

    @Override
    public boolean trySpawnFruitBlock(LevelAccessor level, RandomSource rand, BlockPos pos) {
        return this.defaultGenome.getActiveValue(TreeChromosomes.FRUIT).trySpawnFruitBlock(this.defaultGenome, level, rand, pos);
    }

    @Override
    public List<IProduct> getProducts() {
        return this.defaultGenome.getActiveValue(TreeChromosomes.FRUIT).getProducts();
    }

    @Override
    public List<IProduct> getSpecialties() {
        return this.defaultGenome.getActiveValue(TreeChromosomes.FRUIT).getSpecialty();
    }
}

