/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public enum VanillaWoodType implements IWoodType
{
    OAK(ForestryLeafType.OAK),
    SPRUCE(ForestryLeafType.SPRUCE),
    BIRCH(ForestryLeafType.BIRCH),
    JUNGLE(ForestryLeafType.JUNGLE),
    ACACIA(ForestryLeafType.ACACIA_VANILLA),
    DARK_OAK(ForestryLeafType.DARK_OAK);

    public static final VanillaWoodType[] VALUES;
    private final ForestryLeafType leafType;

    private VanillaWoodType(ForestryLeafType leafType) {
        this.leafType = leafType;
    }

    public static VanillaWoodType getRandom(Random random) {
        return VALUES[random.nextInt(VALUES.length)];
    }

    @Override
    public float getHardness() {
        return 2.0f;
    }

    @Override
    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean setDefaultLeaves(LevelAccessor level, BlockPos pos, IGenome genome, RandomSource rand, @Nullable GameProfile owner) {
        IFruit fruit = genome.getActiveValue(TreeChromosomes.FRUIT);
        FeatureBlockGroup<BlockAbstractLeaves, ForestryLeafType> leavesGroup = fruit.isFruitLeaf() && rand.m_188501_() <= fruit.getFruitChance(genome, level) ? ArboricultureBlocks.LEAVES_DEFAULT_FRUIT : ArboricultureBlocks.LEAVES_DEFAULT;
        BlockState defaultLeaves = ((FeatureBlock)leavesGroup.get(this.leafType)).defaultState();
        return level.m_7731_(pos, defaultLeaves, 19);
    }

    public String m_7912_() {
        return this.toString();
    }

    static {
        VALUES = VanillaWoodType.values();
    }
}

